/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro;

import java.io.PrintStream;
import java.io.PrintWriter;

public class RethrowableException
extends Exception {
    private Exception caught;
    private static final String RETHROW_MESSAGE = "-- secondary stack trace --";

    public RethrowableException() {
    }

    public RethrowableException(String string) {
        super(string);
    }

    public RethrowableException(String string, Exception exception) {
        super(string + System.getProperty("line.separator") + exception);
        this.caught = exception;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.caught != null) {
            System.err.println(RETHROW_MESSAGE);
            this.caught.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.caught != null) {
            printStream.println(RETHROW_MESSAGE);
            this.caught.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.caught != null) {
            printWriter.println(RETHROW_MESSAGE);
            this.caught.printStackTrace(printWriter);
        }
    }
}

