/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.varia;

import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class StringMatchFilter
extends Filter {
    public static final String STRING_TO_MATCH_OPTION = "StringToMatch";
    public static final String ACCEPT_ON_MATCH_OPTION = "AcceptOnMatch";
    boolean acceptOnMatch = true;
    String stringToMatch;

    public int decide(LoggingEvent loggingEvent) {
        if (loggingEvent.message == null || this.stringToMatch == null) {
            return 0;
        }
        if (loggingEvent.message instanceof String) {
            String string = loggingEvent.message;
            if (string.indexOf(this.stringToMatch) == -1) {
                return 0;
            }
            if (this.acceptOnMatch) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public String[] getOptionStrings() {
        return new String[]{STRING_TO_MATCH_OPTION, ACCEPT_ON_MATCH_OPTION};
    }

    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase(STRING_TO_MATCH_OPTION)) {
            this.stringToMatch = string2;
        } else if (string.equalsIgnoreCase(ACCEPT_ON_MATCH_OPTION)) {
            this.acceptOnMatch = OptionConverter.toBoolean(string2, this.acceptOnMatch);
        }
    }
}

