/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class HTMLLayout
extends Layout {
    public static final String LOCATION_INFO_OPTION = "LocationInfo";
    protected final int BUF_SIZE;
    protected final int MAX_CAPACITY;
    private StringBuffer sbuf = new StringBuffer(256);
    boolean locationInfo = false;

    public void activateOptions() {
    }

    public String format(LoggingEvent loggingEvent) {
        if (this.sbuf.capacity() > 1024) {
            this.sbuf = new StringBuffer(256);
        } else {
            this.sbuf.setLength(0);
        }
        this.sbuf.append("\r\n\r\n<tr>");
        this.sbuf.append("<td>");
        this.sbuf.append(loggingEvent.timeStamp - LoggingEvent.getStartTime());
        this.sbuf.append("</td>\r\n");
        this.sbuf.append("<td>");
        this.sbuf.append(loggingEvent.getThreadName());
        this.sbuf.append("</td>\r\n");
        this.sbuf.append("<td>");
        if (loggingEvent.priority.isGreaterOrEqual(Priority.WARN)) {
            this.sbuf.append("<font color=\"#FF0000\">");
            this.sbuf.append(loggingEvent.priority);
            this.sbuf.append("</font>");
        } else {
            this.sbuf.append(loggingEvent.priority);
        }
        this.sbuf.append("</td>\r\n");
        this.sbuf.append("<td>");
        this.sbuf.append(loggingEvent.categoryName);
        this.sbuf.append("</td>\r\n");
        this.sbuf.append("<td>");
        this.sbuf.append(loggingEvent.getNDC());
        this.sbuf.append("</td>\r\n");
        if (this.locationInfo) {
            loggingEvent.setLocationInformation();
            this.sbuf.append("<td>");
            this.sbuf.append(loggingEvent.locationInfo.getFileName());
            this.sbuf.append(':');
            this.sbuf.append(loggingEvent.locationInfo.getLineNumber());
            this.sbuf.append("</td>\r\n");
        }
        this.sbuf.append("<td>");
        this.sbuf.append(loggingEvent.message);
        this.sbuf.append("</td>\r\n");
        this.sbuf.append("</tr>");
        if (loggingEvent.throwable != null) {
            this.sbuf.append("\r\n<tr><td colspan=\"7\">");
            this.sbuf.append(this.getThrowableAsHTML(loggingEvent.throwable));
            this.sbuf.append("</td></tr>");
        }
        return this.sbuf.toString();
    }

    public String getContentType() {
        return "text/html";
    }

    public String getHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body>\r\n");
        stringBuffer.append("<table border=\"1\" cellpadding=\"2\">\r\n<tr>\r\n");
        stringBuffer.append("<th>Time</th><th>Thread</th><th>Priority</th><th>Category</th>");
        stringBuffer.append("<th>NDC</th>");
        if (this.locationInfo) {
            stringBuffer.append("<th>File:Line</th>");
        }
        stringBuffer.append("<th>Message</th></tr>");
        return stringBuffer.toString();
    }

    public String getFooter() {
        return "</table></body></html>";
    }

    public String[] getOptionStrings() {
        return new String[]{LOCATION_INFO_OPTION};
    }

    String getThrowableAsHTML(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        HTMLPrintWriter hTMLPrintWriter = new HTMLPrintWriter(stringWriter);
        throwable.printStackTrace(hTMLPrintWriter);
        return stringWriter.toString();
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void setOption(String string, String string2) {
        if (string2 == null) {
            return;
        }
        if (string.equals(LOCATION_INFO_OPTION)) {
            this.locationInfo = OptionConverter.toBoolean(string2, this.locationInfo);
        }
    }

    public HTMLLayout() {
        this.BUF_SIZE = 256;
        this.MAX_CAPACITY = 1024;
    }

    static class HTMLPrintWriter
    extends PrintWriter {
        static String TRACE_PREFIX = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";

        public void println(char[] cArray) {
            this.write(TRACE_PREFIX);
            this.write(cArray);
        }

        public void println(String string) {
            this.write(TRACE_PREFIX);
            this.write(string);
        }

        public HTMLPrintWriter(Writer writer) {
            super(writer);
        }
    }
}

