import gtk
import gobject
import sys
import re
import string
import threading
import datetime
import threading

#Skype4Py
import Skype4Py

# for debugging
import pdb

REV="$Rev: 67 $"

class FetchSMS(threading.Thread):
	def __init__(self, skype_obj, listsms_obj):
		self.skype = skype_obj
		self.listsms = listsms_obj
		super(FetchSMS, self).__init__()

	def run(self):
		for sms in self.skype.Smss:
			self.listsms.update_smss(sms)

		self.listsms.register_handles()

class ListSMS:
	def __init__(self, skype_obj, phones):
		# Vars
		self.ts_lock = threading.Lock()
		self.ts_smss = gtk.ListStore(int, str, str, str, str, object)
		self.smslist = {}

		self.skype = skype_obj
		self.phones = phones
		self.fetch = FetchSMS(self.skype, self)

	def start(self):
		self.fetch.start()

	def register_handles(self):
		self.skype.RegisterEventHandler('SmsMessageStatusChanged', 
			self.SmsMessageStatusChanged)
		self.skype.RegisterEventHandler('SmsTargetStatusChanged', 
			self.SmsTargetStatusChanged)


	def update_smss(self, sms):
		self.ts_lock.acquire()
		founditer = False
		if self.smslist.has_key(sms.Id):
			founditer = self.smslist[sms.Id]

		if sms.Timestamp == 0.0:
			smsdate = "Never sent!"
		else:
			smsdate = str(datetime.datetime.fromtimestamp(int(sms.Timestamp)))

		s=""
		count = 0
		last = len(sms.Targets)
		for target in sms.Targets:
			if target.Number in self.phones:
				s += self.phones[target.Number]+": "
			else: 
				s += target.Number+": "
			s += self.skype.Convert.SmsTargetStatusToText(target.Status)
			count += 1
			if count < last:
				s += "\n"
			
		gtk.gdk.threads_enter()
		if founditer:
			self.ts_smss.set(founditer, 
				0, sms.Id, 
	 			1, smsdate, 
	 			2, s, 
	 			3, sms.Body,
	 			4, self.skype.Convert.SmsMessageStatusToText(sms.Status),
	 			5, sms
				)
		else:
			self.smslist[sms.Id] = self.ts_smss.append([sms.Id,
				smsdate,
				s, 
	 			sms.Body,
	 			self.skype.Convert.SmsMessageStatusToText(sms.Status),
	 			sms
				])
		gtk.gdk.threads_leave()
		self.ts_lock.release()


	def SmsMessageStatusChanged(self, sms, status):
		self.update_smss(sms)

	def SmsTargetStatusChanged(self, target, status):
		sms = target.Message
		self.update_smss(sms)

	def popup(self, widget, event):
		if event.button == 3:
			x = int(event.x)
			y = int(event.y)
			tuple = self.tv_smss.get_path_at_pos(x, y)
			if tuple is not None:
				rowpath, col, cellx, celly = tuple
				self.popup_menu_pop(widget, rowpath, event)

		return False
	
	def popup_menu_pop(self, widget, path, event):
		self.popup_menu = gtk.Menu()
		menu_item = gtk.MenuItem('Delete')
		menu_item.connect("activate", self.popup_menu_delete, path)
		self.popup_menu.append(menu_item)

		self.popup_menu.show_all()
		self.popup_menu.popup(None, None, None, event.button,
				event.time)

	def delete_sms(self, treeiter):
		value = self.ts_smss.get_value(treeiter, 0)
		sms = self.ts_smss.get_value(treeiter, 5)
		sms.Delete()
		self.ts_smss.remove(treeiter)
		del self.smslist[sms.Id]

	def popup_menu_delete(self, widget, path):
		treeiter = self.ts_smss.get_iter(path)
		self.delete_sms(treeiter)

	def delete_selected(self, event):
		treestore,selected = self.tv_smss.get_selection().get_selected_rows()
		iters = [treestore.get_iter(path) for path in selected]
		for iter in iters:
			self.delete_sms(iter)

	def window_list_sms(self):
		vbox = gtk.VBox(False, 0)

		label = gtk.Label("SMS List")
		label.set_markup("<span size=\"large\" weight=\"bold\">SMS List</span>")
		vbox.pack_start(label, False, False, 0)
		label.show()

		sw = gtk.ScrolledWindow()
		sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)

		self.tv_smss = gtk.TreeView(self.ts_smss)
		self.tv_smss.connect("button-press-event", self.popup)
		self.tv_smss.get_selection().set_mode(gtk.SELECTION_MULTIPLE)

		self.tvcolumn = gtk.TreeViewColumn('ID')
		self.tv_smss.append_column(self.tvcolumn)
		self.cell = gtk.CellRendererText()
		self.tvcolumn.pack_start(self.cell, True)
		self.tvcolumn.add_attribute(self.cell, 'text', 0)
		self.tvcolumn.set_sort_column_id(0)

		self.tvcolumn = gtk.TreeViewColumn('Date')
		self.tv_smss.append_column(self.tvcolumn)
		self.cell = gtk.CellRendererText()
		self.tvcolumn.pack_start(self.cell, True)
		self.tvcolumn.add_attribute(self.cell, 'text', 1)
		self.tvcolumn.set_sort_column_id(1)

		self.tvcolumn = gtk.TreeViewColumn('To')
		self.tv_smss.append_column(self.tvcolumn)
		self.cell = gtk.CellRendererText()
		self.tvcolumn.pack_start(self.cell, True)
		self.tvcolumn.add_attribute(self.cell, 'text', 2)
		self.tvcolumn.set_sort_column_id(2)

		self.tvcolumn = gtk.TreeViewColumn('Body')
		self.tv_smss.append_column(self.tvcolumn)
		self.cell = gtk.CellRendererText()
		self.tvcolumn.pack_start(self.cell, True)
		self.tvcolumn.add_attribute(self.cell, 'text', 3)
		self.tvcolumn.set_sort_column_id(3)

		self.tvcolumn = gtk.TreeViewColumn('Status')
		self.tv_smss.append_column(self.tvcolumn)
		self.cell = gtk.CellRendererText()
		self.tvcolumn.pack_start(self.cell, True)
		self.tvcolumn.add_attribute(self.cell, 'text', 4)
		self.tvcolumn.set_sort_column_id(4)

		self.tv_smss.set_search_column(0)
		self.tv_smss.set_reorderable(True)

		sw.add(self.tv_smss)
		self.tv_smss.show()
		vbox.pack_start(sw, True, True, 0)
		sw.show()

		button = gtk.Button('Delete selected')
		button.connect("clicked", self.delete_selected)
		vbox.pack_start(button, False, True, 0)
		button.show()
		vbox.show()

		return vbox
		
