#ifdef __APPLE__

#include "seaview.h"
#include <string.h>
#include <stdio.h>
#include <FL/Fl_Sys_Menu_Bar.H>

// included functions
extern "C" {
char *my_fgets(char *s, int n, FILE *f);
void *memccpy(void *s1, const void *s2, int c, size_t n);
char *get_prog_dir(void);
void MG_FSSpecToPathname (FSSpec *myFSS, char *fname, int maxl);
void PtoC(const void *in, void *out);
void CtoP(const void *in, void *out);
void MGinit_apple_events(SEA_VIEW *);
void add_apropos(char *progname);
void show_apropos(Fl_Widget *, void *);
pascal Boolean myfilter(DialogRef dptr, EventRecord *event, DialogItemIndex *item);
Boolean AppleEventsInstalled ();
pascal OSErr  MyHandleODoc (const AppleEvent *theAppleEvent, AppleEvent* reply,  UInt32 handlerRefCon);
pascal OSErr  MyHandlePDoc (const AppleEvent *theAppleEvent, AppleEvent *reply, UInt32 handlerRefCon);
pascal OSErr  MyHandleOApp (const AppleEvent *theAppleEvent, AppleEvent *reply, UInt32 handlerRefCon);
pascal OSErr  MyHandleQApp (const AppleEvent *theAppleEvent, AppleEvent *reply, UInt32 handlerRefCon);
OSErr MyGotRequiredParams (const AppleEvent *theAppleEvent);
}

static SEA_VIEW *view;
extern void use_initial_file(SEA_VIEW *view, char *masename);

#elif defined(WIN32)

#include <stdarg.h>
#include <windef.h>
#include <winbase.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

/* included functions */
extern "C" {
void my_bell(void);
void *memccpy(void *s1, const void *s2, int c, size_t n);
int mysystem(const char *command);
char *get_prog_dir(void);
void add_to_path(char *dir);
}
#endif



void *memccpy(void *s1, const void *s2, int c, size_t n)
{
char *p, *q;
p = (char *)s1; q = (char *)s2;
while(n-- > 0) {
	*p = *(q++);
	if( *(p++) == c) return p;
	}
return 0;
}


#ifdef __APPLE__
/* version de fgets qui accepte les formats CR, LF, ou CR+LF sur Mac.
!!!!!!!!!!! sur Mac, fgets change les \r et \n lus dans les fichiers !!!!!!!!!!!!!
!!!!!!!!!!! donc le format PC des fichiers apparait comme LF+CR !!!!!!!!!!!!!!
!!!!!!!!!!! et le format unix comme CR !!!!!!!!!!!!!
*/

char *my_fgets(char *s, int n, FILE *f)
{
int next_char;
char *p;

p = s;
while(--n > 0) {
	next_char = getc(f);
	if( next_char == '\r' ) {
		*(p++) = '\n';
		break;
		}
	else if( next_char == '\n' ) {
		*(p++) = '\n';
		next_char = getc(f);
		if(next_char != '\r' && next_char != EOF) {
			ungetc(next_char, f);
			}
		break;
		}
 	else if (next_char == EOF) 
		break;
	*(p++) = next_char;
	}
*p = 0;
return (p == s ? NULL : s);
}


char *get_prog_dir(void)
/* returns the pathname of the directory containing the running program
*/
{
FSSpec fspec;
ProcessInfoRec info;
ProcessSerialNumber psn;
OSErr err;
static char myname[300];
char *p;

info.processInfoLength = sizeof(ProcessInfoRec);
info.processName = NULL;
info.processAppSpec = &fspec;
err = GetCurrentProcess(&psn);
if(err != noErr) return NULL;
err = GetProcessInformation(&psn, &info);
if(err != noErr) return NULL;
MG_FSSpecToPathname(&fspec, myname, sizeof(myname) );
p = strrchr(myname, ':');
if(p == NULL) return NULL;
*p = 0;
return myname;
}


void MG_FSSpecToPathname (FSSpec *myFSS, char *fname, int maxl)
{
FSRef myFSRef, pFSRef;
FSCatalogInfo myinfo;
static int  anErr = noErr;
char *p, *q;
static char buffer[1000], name[256];
FSSpec fsspec;

p = buffer;
anErr = FSpMakeFSRef(myFSS, &myFSRef);
while(1) {
	anErr = FSGetCatalogInfo(&myFSRef, kFSCatInfoParentDirID, &myinfo, NULL, &fsspec, &pFSRef);
	PtoC(fsspec.name, name);
	/* add the file or dir name to the end of buffer in reverse orientation */
	q = name + strlen(name) - 1;
	while(q >= name) { *p = *q; q--; p++; }
	if(myinfo.parentDirID == fsRtParID) break; /* detect when top level is reached */
	*p = ':'; p++;
	myFSRef = pFSRef;
	}
*p = 0;
/* invert buffer into fname */
maxl--;
if(maxl > strlen(buffer)) maxl = strlen(buffer);
q = buffer + maxl - 1;
p = fname;
while(q >= buffer) { *p = *q; q--; p++; }
fname[maxl] = 0;
}



void PtoC(const void *in, void *out)
{
char *vin = (char *)in;
char *vout = (char *)out;
int l = *vin;

if(l > 0) memcpy(vout, vin + 1, l);
vout[l] = 0;
}


void CtoP(const void *in, void *out)
{
char *vout = (char *)out;
int l;
if(in == NULL) l = 0;
else	{
	l = strlen( (char *)in );
	memcpy(vout + 1, in, l);
	}
vout[0] = l;
}


void MGinit_apple_events(SEA_VIEW *v)
{
//	long gestaltAnswer;
	OSErr gestaltErr, theResult;
	OSErr err;

	AEEventHandlerUPP	gAEEventHandlerUPPODoc;
	AEEventHandlerUPP	gAEEventHandlerUPPOApp;
	AEEventHandlerUPP	gAEEventHandlerUPPPDoc;
	AEEventHandlerUPP	gAEEventHandlerUPPQApp;
Boolean aEvents;
	aEvents = AppleEventsInstalled();
	if (aEvents) {
		gAEEventHandlerUPPODoc = NewAEEventHandlerUPP(MyHandleODoc);
		gAEEventHandlerUPPOApp = NewAEEventHandlerUPP(MyHandleOApp);
		gAEEventHandlerUPPPDoc = NewAEEventHandlerUPP(MyHandlePDoc);
		gAEEventHandlerUPPQApp = NewAEEventHandlerUPP(MyHandleQApp);
		err = AEInstallEventHandler (kCoreEventClass, kAEOpenDocuments, gAEEventHandlerUPPODoc,0, 0);
		err = AEInstallEventHandler (kCoreEventClass, kAEOpenApplication, gAEEventHandlerUPPOApp,0, 0);
		err = AEInstallEventHandler (kCoreEventClass, kAEPrintDocuments, gAEEventHandlerUPPPDoc,0, 0);
		err = AEInstallEventHandler (kCoreEventClass, kAEQuitApplication, gAEEventHandlerUPPQApp,0, 0);
	}
view = v;
}


void add_apropos(char *progname)
{  
static Fl_Menu_Item item = {"", 0, show_apropos, 0, 0};
OSStatus err;
MenuRef mr;
char title[256];
Str255 ptitle;

const unsigned char apple_glyph[2] = "\p\024";

Fl_Sys_Menu_Bar *smb = new Fl_Sys_Menu_Bar(0,0,0,0);
Fl_Menu_Item empty = {0, 0, NULL, 0, 0};
smb->menu( &empty ); // indispensable pour initialiser fl_sys_menu_bar
mr = NewMenu(1, apple_glyph);
InsertMenu(mr, 0);
sprintf(title, "About %s", progname);
CtoP(title, ptitle);
err = InsertMenuItemText(mr, ptitle, 0);
err = SetMenuItemRefCon(mr, 1, (UInt32) (&item));
}


void show_apropos(Fl_Widget *w, void *data)
{
DialogItemIndex tmp;
DialogRef dptr;

dptr = GetNewDialog(129, NULL, (WindowPtr)-1L);
ModalDialog(  NewModalFilterUPP(myfilter), &tmp);
DisposeDialog(dptr);
}


pascal Boolean myfilter(DialogPtr dptr, EventRecord *event, DialogItemIndex *item)
{
if(event->what == mouseDown) {
	*item = 1;
	return TRUE;
	}
else 
	return FALSE;
}


/***********************************************************************/
Boolean AppleEventsInstalled ()
{
	OSErr err;
	long  result;

	err = Gestalt (gestaltAppleEventsAttr, &result);
	return (!err && ((result >> gestaltAppleEventsPresent) & 0x0001));
											// return TRUE if there is no
											// error and the proper bit of
											// result is set
}

/***********************************************************************/
pascal OSErr  MyHandleODoc (const AppleEvent *theAppleEvent, AppleEvent* reply, UInt32 handlerRefCon)
{
	FSSpec	myFSS;
	AEDescList	docList;
	OSErr	err;
	long	index, itemsInList;
	Size	actualSize;
	AEKeyword	keywd;
	DescType	returnedType;
	FSRef myFSRef;
	FSCatalogInfo myinfo;
	char masename[300];
	known_format defaultformat;

	err = AEGetParamDesc (theAppleEvent, keyDirectObject, typeAEList,
			&docList);
	if (err) return err;

	err = MyGotRequiredParams (theAppleEvent);
	if (err) return err;

	err = AECountItems (&docList, &itemsInList);

	index = 1;
	err = AEGetNthPtr (&docList, index, typeFSS, &keywd,
		&returnedType, (Ptr) &myFSS, sizeof(myFSS), &actualSize);
	if (err) return err;
	
	MG_FSSpecToPathname(&myFSS, masename, sizeof(masename) );
	use_initial_file(view, masename);
	err = AEDisposeDesc (&docList);
	return noErr;
}

/***********************************************************************/
pascal OSErr  MyHandlePDoc (const AppleEvent *theAppleEvent, AppleEvent *reply, UInt32 handlerRefCon)
{
	FSSpec	myFSS;
	AEDescList	docList;
	OSErr	err;
	long	index,
					itemsInList;
	Size	actualSize;
	AEKeyword	keywd;
	DescType	returnedType;
	char		fname[256], dirname[256];
	
	// get the direct parameter--a descriptor list--and put it into a docList
	err = AEGetParamDesc (theAppleEvent, keyDirectObject, typeAEList,
									&docList);
	if (err)
			return err;

	// check for missing parameters
	err = MyGotRequiredParams (theAppleEvent);
	if (err)
			return err;

	// count the number of descriptor records in the list
	err = AECountItems (&docList, &itemsInList);

	// now get each descriptor record from the list, coerce the returned
	// data to an FSSpec record, and open the associated file
	
	return noErr;

}

/***********************************************************************/
pascal OSErr  MyHandleOApp (const AppleEvent *theAppleEvent, AppleEvent *reply, UInt32 handlerRefCon)
{
	// Ouverture de l'appli
	return noErr;
}

/***********************************************************************/
pascal OSErr  MyHandleQApp (const AppleEvent *theAppleEvent, AppleEvent *reply, UInt32 handlerRefCon)
{
	// Quitte l'appli
//	quitAEReceived = 1;
	ExitToShell();
	return noErr;
}

/***********************************************************************/
OSErr MyGotRequiredParams (const AppleEvent *theAppleEvent)
{
	DescType	returnedType;
	Size	actualSize;
	OSErr	err;

	err = AEGetAttributePtr (theAppleEvent, keyMissedKeywordAttr,
									typeWildCard, &returnedType, nil, 0,
									&actualSize);
	if (err == errAEDescNotFound)	// you got all the required parameters
			return noErr;
	else if (!err)				// you missed a required parameter
			return errAEEventNotHandled;
	else						// the call to AEGetAttributePtr failed
			return err;
}


#endif



#ifdef WIN32


void add_to_path(char *dir)
/* ajoute a la variable PATH la directory dir
teste si deja dedans ou si vide */
{
char *buffer;
int l;

if(dir == NULL || strlen(dir) == 0) return;
buffer = (char *)malloc(10000);
l = GetEnvironmentVariable("PATH", buffer, 10000);
if(l == 0) *buffer = 0;
//fprintf(OUT,"l=%d PATH=%s\n",l,buffer);fflush(OUT);
if(strstr(buffer, dir) != NULL) return;
if(*buffer != 0) strcat(buffer, ";");
strcat(buffer, dir);
SetEnvironmentVariable("PATH", buffer);

//GetEnvironmentVariable("PATH", buffer, sizeof(buffer));
//fprintf(OUT,"PATH=%s\n",buffer);fflush(OUT);

free(buffer);
}


int mysystem(const char *command)
/*
command contains "prog.exe args"
prog is searched in dir where calling program was launched, current dir,
windows system dir, windows dir, dirs in PATH.
*/
{
static char buf[100];
STARTUPINFO info;
PROCESS_INFORMATION pi;
int retval;
GetStartupInfo(&info);
//fprintf(OUT,"retour GetStartupInfo \n");fflush(OUT);
retval = CreateProcess(NULL, (char *)command,0,0,0,0,0,_getcwd(buf,sizeof(buf)),&info,&pi);
//fprintf(OUT,"retour CreateProcess bool retval=%d\n",retval);fflush(OUT);
retval = WaitForSingleObject(pi.hProcess, INFINITE);
//fprintf(OUT,"retour WaitForSingleObject retval=%d WAIT_FAILED=%d\n",retval,WAIT_FAILED);fflush(OUT);
return (retval == WAIT_FAILED);
}

char *get_prog_dir(void)
/* returns path of dir where calling program was launched */
{
static char dir[100];
char *line, *p;
int l;

line = GetCommandLine();
//fprintf(OUT,"retour GetCommandLine line=%s\n",line);fflush(OUT);
/* extract 1st word of line or first group delimited by " " */
if(*line == '"') { line++; p = strchr(line, '"'); }
else
	p = strchr(line, ' '); 
if(p == NULL) p = line + strlen(line);
l = p - line;
while( l > 0 && line[l - 1] != '\\' ) l--;
if(l <= 0) return NULL;
memcpy(dir, line, l); dir[l] = 0;
return dir;
}


void my_bell(void)
{
Beep(0,0);
}


/*
char **split_args(char *all, int *pargc)
{
char *p, *q, **argv;
int l, argc = 0;

// compter les arguments
p = all;
while(*p != 0) {
	argc++;
	if(*p == '"') p = strchr(p+1, '"');
	else p = strchr(p, ' ');
	if(p == NULL) break;
	p++;
	while(*p == ' ') p++;
	}
argv = (char **)malloc(argc * sizeof(char *));
*pargc = argc;
// separer les arguments, enlever les "" encadrantes si presentes
p = all; argc = 0;
while(*p != 0) {
	if(*p == '"') { p++; q = strchr(p, '"'); }
	else q = strchr(p, ' ');
	if(q == NULL) q = p + strlen(p);
	l = q - p; 
	argv[argc] = (char *)malloc(l + 1);
	memcpy(argv[argc], p, l); argv[argc][l] = 0;
	if(*q == 0) break;
	p = q + 1;
	while(*p == ' ') p++;
	argc++;
	}
return argv;
}
*/

#endif
