#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <linux/soundcard.h>
#include "common.h"

#define AUDIO_DEV "/dev/dsp"

int audio_fd;

void init_audio()
{
	int fs=0x7fff0007,rate=FS,bits=8,stereo=0;

	if ((audio_fd=open(AUDIO_DEV, O_RDONLY)) == -1) {
		fprintf(stderr, "Cannot open sound device");
		exit(0);
	}

        /* Set fragment size to 128 bytes */
        if (ioctl(audio_fd, SNDCTL_DSP_SETFRAGMENT, &fs)) {
        	fprintf(stderr, "Cannot set fragment size\n");
        }
        if (ioctl(audio_fd, SNDCTL_DSP_SAMPLESIZE, &bits) == EOF) {
                fprintf(stderr, "Cannot set %d bits/sample\n",bits);
        }
        if (ioctl(audio_fd, SNDCTL_DSP_STEREO, &stereo) == EOF) {
                fprintf(stderr, "Cannot set %ld channel(s)\n",stereo+1);
        }
        if (ioctl(audio_fd, SNDCTL_DSP_SPEED, &rate) == EOF) {
                fprintf(stderr, "Cannot set rate %d Hz\n",rate);
        }
}

#define NBUF 128

float get_audio_sample()

{
	static int bp=0,ns=0;
	static unsigned char audio_buf[NBUF];

	if (bp==ns) {
		ns=read(audio_fd,audio_buf,NBUF);
		bp=0;
	}
	return (float)(audio_buf[bp++]-128);
}
