/*
 * Copyright (c) 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Fernando Nasser
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.vise.resources;

import java.util.ListResourceBundle;
import java.awt.Event;
import java.awt.event.KeyEvent;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

/**
 * ActionResources.java
 *
 * @author <a href="mailto:fnasser@redhat.com">Fernando Nasser</a>
 *
 * @version 1.2.0
 */

public class ActionResources_pt_BR extends ListResourceBundle {

	public Object[][] getContents()
	{
		return contents;
	}

	private static final Object[][] contents = {
		{ ActionResources.NEW_NAME,                "Novo" },
		//{ ActionResources.NEW_COMMAND,             "new" },
		{ ActionResources.NEW_SHORTDESC,           "Novo" },
		{ ActionResources.NEW_LONGDESC,            "Novo" },
		//{ ActionResources.NEW_SMALLICON,           "new16.png" },
		//{ ActionResources.NEW_LARGEICON,           "new24.png" },
		{ ActionResources.NEW_ACCELERATOR,         KeyStroke.getKeyStroke(KeyEvent.VK_N, Event.CTRL_MASK) },
		{ ActionResources.NEW_MNEMONIC,            new Integer(KeyEvent.VK_N) },

		{ ActionResources.SAVE_NAME,               "Salvar" },
		//{ ActionResources.SAVE_COMMAND,            "save" },
		{ ActionResources.SAVE_SHORTDESC,          "Salvar" },
		{ ActionResources.SAVE_LONGDESC,           "Salvar" },
		//{ ActionResources.SAVE_SMALLICON,          "save16.png" },
		//{ ActionResources.SAVE_LARGEICON,          "save24.png" },
		{ ActionResources.SAVE_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_S, Event.CTRL_MASK) },
		{ ActionResources.SAVE_MNEMONIC,           new Integer(KeyEvent.VK_S) },
		
		{ ActionResources.SAVEAS_NAME,             "Salvar Como..." },
		//{ ActionResources.SAVEAS_COMMAND,          "saveas" },
		{ ActionResources.SAVEAS_SHORTDESC,        "Salvar Como" },
		{ ActionResources.SAVEAS_LONGDESC,         "Salvar Como" },
		//{ ActionResources.SAVEAS_SMALLICON,        "saveas16.png" },
		//{ ActionResources.SAVEAS_LARGEICON,        "saveas24.png" },
		{ ActionResources.SAVEAS_MNEMONIC,         new Integer(KeyEvent.VK_C) },
		{ ActionResources.SAVEAS_MNEMONIC_INDEX,   new Integer(7) },

		{ ActionResources.OPEN_NAME,               "Abrir..." },
		//{ ActionResources.OPEN_COMMAND,            "open" },
		{ ActionResources.OPEN_SHORTDESC,          "Abrir" },
		{ ActionResources.OPEN_LONGDESC,           "Abrir" },
		//{ ActionResources.OPEN_SMALLICON,          "open16.png" },
		//{ ActionResources.OPEN_LARGEICON,          "open24.png" },
		{ ActionResources.OPEN_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK) },
		{ ActionResources.OPEN_MNEMONIC,           new Integer(KeyEvent.VK_A) },

		{ ActionResources.CUT_NAME,                "Cortar" },
		//{ ActionResources.CUT_COMMAND,             "cut" },
		{ ActionResources.CUT_SHORTDESC,           "Cortar" },
		{ ActionResources.CUT_LONGDESC,            "Cortar" },
		//{ ActionResources.CUT_SMALLICON,           "cut16.png" },
		//{ ActionResources.CUT_LARGEICON,           "cut24.png" },
		{ ActionResources.CUT_ACCELERATOR,         KeyStroke.getKeyStroke(KeyEvent.VK_X, Event.CTRL_MASK) },
		{ ActionResources.CUT_MNEMONIC,            new Integer(KeyEvent.VK_R) },

		{ ActionResources.COPY_NAME,               "Copiar" },
		//{ ActionResources.COPY_COMMAND,            "copy" },
		{ ActionResources.COPY_SHORTDESC,          "Copiar" },
		{ ActionResources.COPY_LONGDESC,           "Copiar" },
		//{ ActionResources.COPY_SMALLICON,          "copy16.png" },
		//{ ActionResources.COPY_LARGEICON,          "copy24.png" },
		{ ActionResources.COPY_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_C, Event.CTRL_MASK) },
		{ ActionResources.COPY_MNEMONIC,           new Integer(KeyEvent.VK_C) },

		{ ActionResources.PASTE_NAME,              "Colar" },
		//{ ActionResources.PASTE_COMMAND,           "paste" },
		{ ActionResources.PASTE_SHORTDESC,         "Colar" },
		{ ActionResources.PASTE_LONGDESC,          "Colar" },
		//{ ActionResources.PASTE_SMALLICON,         "paste16.png" },
		//{ ActionResources.PASTE_LARGEICON,         "paste24.png" },
		{ ActionResources.PASTE_ACCELERATOR,       KeyStroke.getKeyStroke(KeyEvent.VK_V, Event.CTRL_MASK) },
		{ ActionResources.PASTE_MNEMONIC,          new Integer(KeyEvent.VK_L) },

		{ ActionResources.MANUAL_NAME,             "Manual..." },
		//{ ActionResources.MANUAL_COMMAND,        "manual" },
		{ ActionResources.MANUAL_SHORTDESC,        "Manual" },
		{ ActionResources.MANUAL_LONGDESC,         "Manual" },
		//{ ActionResources.MANUAL_SMALLICON,      "help16.png" },
		//{ ActionResources.MANUAL_LARGEICON,      "help24.png" },
		//{ ActionResources.MANUAL_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0) },
		{ ActionResources.MANUAL_MNEMONIC,         new Integer(KeyEvent.VK_M) },

		{ ActionResources.ABOUT_NAME,              "Sobre..." },
		//{ ActionResources.ABOUT_COMMAND,           "about" },
		{ ActionResources.ABOUT_SHORTDESC,         "Sobre" },
		{ ActionResources.ABOUT_LONGDESC,          "Sobre" },
		//{ ActionResources.ABOUT_SMALLICON,         "about16.png" },
		//{ ActionResources.ABOUT_LARGEICON,         "about24.png" },
		{ ActionResources.ABOUT_MNEMONIC,          new Integer(KeyEvent.VK_S) },

		{ ActionResources.EXIT_NAME,               "Sair" },
		//{ ActionResources.EXIT_COMMAND,            "exit" },
		{ ActionResources.EXIT_SHORTDESC,          "Sair" },
		{ ActionResources.EXIT_LONGDESC,           "Sair" },
		//{ ActionResources.EXIT_SMALLICON,          "exit16.png" },
		//{ ActionResources.EXIT_LARGEICON,          "exit24.png" },
		{ ActionResources.EXIT_MNEMONIC,           new Integer(KeyEvent.VK_R) },

		{ ActionResources.EXPLAIN_NAME,            "Explain" },
		//{ ActionResources.EXPLAIN_COMMAND,         "explain" },
		{ ActionResources.EXPLAIN_SHORTDESC,       "Explain" },
		{ ActionResources.EXPLAIN_LONGDESC,        "Explain" },
		//{ ActionResources.EXPLAIN_SMALLICON,       "explain16.png" },
		//{ ActionResources.EXPLAIN_LARGEICON,       "explain24.png" },
		{ ActionResources.EXPLAIN_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_E, Event.CTRL_MASK) },
		{ ActionResources.EXPLAIN_MNEMONIC,        new Integer(KeyEvent.VK_E) },

		{ ActionResources.PREFERENCES_NAME,        "Prefer\u00EAncias..." },
		//{ ActionResources.PREFERENCES_COMMAND,     "preferences" },
		{ ActionResources.PREFERENCES_SHORTDESC,   "Editar Prefer\u00EAncias" },
		{ ActionResources.PREFERENCES_LONGDESC,    "Editar Prefer\u00EAncias" },
		//{ ActionResources.PREFERENCES_SMALLICON,   "prefs16.png" },
		//{ ActionResources.PREFERENCES_LARGEICON,   "prefs24.png" },
		{ ActionResources.PREFERENCES_MNEMONIC,    new Integer(KeyEvent.VK_P) },

		{ ActionResources.DATABASES_NAME,          "Databases..." },
		//{ ActionResources.DATABASES_COMMAND,       "databases" },
		{ ActionResources.DATABASES_SHORTDESC,     "Editar Databases" },
		{ ActionResources.DATABASES_LONGDESC,      "Editar Databases" },
		{ ActionResources.DATABASES_MNEMONIC,      new Integer(KeyEvent.VK_D) },

		{ ActionResources.PLANNEROPTIONS_NAME,      "Op\u00E7\u00F5es do Planner..." },
		//{ ActionResources.PLANNEROPTIONS_COMMAND,   "planneroptions" },
		{ ActionResources.PLANNEROPTIONS_SHORTDESC, "Editar Op\u00E7\u00F5es do Planner" },
		{ ActionResources.PLANNEROPTIONS_LONGDESC,  "Editar Op\u00E7\u00F5es do Planner" },
		{ ActionResources.PLANNEROPTIONS_MNEMONIC,  new Integer(KeyEvent.VK_O) },

		{ ActionResources.ZOOMIN_NAME,             "Aproximar" },
		//{ ActionResources.ZOOMIN_COMMAND,          "zoomin" },
		{ ActionResources.ZOOMIN_SHORTDESC,        "Aproximar" },
		{ ActionResources.ZOOMIN_LONGDESC,         "Aproximar" },
		//{ ActionResources.ZOOMIN_SMALLICON,        "zoomin16.png" },
		//{ ActionResources.ZOOMIN_LARGEICON,        "zoomin24.png" },
		{ ActionResources.ZOOMIN_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_EQUALS, Event.CTRL_MASK) },
		{ ActionResources.ZOOMIN_MNEMONIC,         new Integer(KeyEvent.VK_P) },

		{ ActionResources.ZOOMOUT_NAME,            "Afastar" },
		//{ ActionResources.ZOOMOUT_COMMAND,         "zoomout" },
		{ ActionResources.ZOOMOUT_SHORTDESC,       "Afastar" },
		{ ActionResources.ZOOMOUT_LONGDESC,        "Afastar" },
		//{ ActionResources.ZOOMOUT_SMALLICON,       "zoomout16.png" },
		//{ ActionResources.ZOOMOUT_LARGEICON,       "zoomout24.png" },
		{ ActionResources.ZOOMOUT_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_MINUS, Event.CTRL_MASK) },
		{ ActionResources.ZOOMOUT_MNEMONIC,        new Integer(KeyEvent.VK_F) },

		{ ActionResources.DELETE_NAME,             "Deletar" },
		//{ ActionResources.DELETE_COMMAND,          "delete" },
		{ ActionResources.DELETE_SHORTDESC,        "Deletar" },
		{ ActionResources.DELETE_LONGDESC,         "Deletar" },
		{ ActionResources.DELETE_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_D, Event.CTRL_MASK) },
		{ ActionResources.DELETE_MNEMONIC,         new Integer(KeyEvent.VK_D) },

		{ ActionResources.EDIT_NAME,               "Editar" },
		//{ ActionResources.EDIT_COMMAND,            "edit" },
		{ ActionResources.EDIT_SHORTDESC,          "Editar" },
		{ ActionResources.EDIT_LONGDESC,           "Editar" },
		{ ActionResources.EDIT_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_E, Event.CTRL_MASK) },
		{ ActionResources.EDIT_MNEMONIC,           new Integer(KeyEvent.VK_E) },

		{ ActionResources.OK_NAME,                 "OK" },
		//{ ActionResources.OK_COMMAND,              "ok" },
		{ ActionResources.OK_SHORTDESC,            "OK" },
		{ ActionResources.OK_LONGDESC,             "OK" },
		{ ActionResources.OK_ACCELERATOR,          KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK) },
		{ ActionResources.OK_MNEMONIC,             new Integer(KeyEvent.VK_O) },

		{ ActionResources.CANCEL_NAME,             "Cancelar" },
		//{ ActionResources.CANCEL_COMMAND,          "cancel" },
		{ ActionResources.CANCEL_SHORTDESC,        "Cancelar" },
		{ ActionResources.CANCEL_LONGDESC,         "Cancelar" },
		{ ActionResources.CANCEL_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_C, Event.CTRL_MASK) },
		{ ActionResources.CANCEL_MNEMONIC,         new Integer(KeyEvent.VK_C) },

		{ ActionResources.TEST_NAME,               "Testar" },
		//{ ActionResources.TEST_COMMAND,            "test" },
		{ ActionResources.TEST_SHORTDESC,          "Testar" },
		{ ActionResources.TEST_LONGDESC,           "Testar" },
		{ ActionResources.TEST_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_T, Event.CTRL_MASK) },
		{ ActionResources.TEST_MNEMONIC,           new Integer(KeyEvent.VK_T) },

		{ ActionResources.REFRESH_NAME,            "Refrescar" },
		//{ ActionResources.REFRESH_COMMAND,         "refresh" },
		{ ActionResources.REFRESH_SHORTDESC,       "Refrescar" },
		{ ActionResources.REFRESH_LONGDESC,        "Refrescar" },
		//{ ActonResources.REFRESH_SMALLICON,	     "refresh16.png" },
		//{ ActionResources.REFRESH_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_F5, 0) },
		{ ActionResources.REFRESH_MNEMONIC,        new Integer(KeyEvent.VK_R) },

		{ ActionResources.CONTINUE_NAME,           "Continuar" },
		//{ ActionResources.CONTINUE_COMMAND,        "continue" },
		{ ActionResources.CONTINUE_SHORTDESC,      "Continuar" },
		{ ActionResources.CONTINUE_LONGDESC,       "Continuar" },
		{ ActionResources.CONTINUE_ACCELERATOR,    KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK) },
		{ ActionResources.CONTINUE_MNEMONIC,       new Integer(KeyEvent.VK_O) },

		{ ActionResources.BACK_NAME,               "Voltar" },
		//{ ActionResources.BACK_COMMAND,            "back" },
		{ ActionResources.BACK_SHORTDESC,          "Voltar" },
		{ ActionResources.BACK_LONGDESC,           "Voltar" },
		//{ ActionResources.BACK_LARGEICON,          "back24.png" },
		{ ActionResources.BACK_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, Event.CTRL_MASK) },
		{ ActionResources.BACK_MNEMONIC,           new Integer(KeyEvent.VK_B) },

		{ ActionResources.FORWARD_NAME,            "Avancar" },
		//{ ActionResources.FORWARD_COMMAND,         "forward" },
		{ ActionResources.FORWARD_SHORTDESC,       "Avancar" },
		{ ActionResources.FORWARD_LONGDESC,        "Avancar" },
		//{ ActionResources.FORWARD_LARGEICON,       "forward24.png" },
		{ ActionResources.FORWARD_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, Event.CTRL_MASK) },
		{ ActionResources.FORWARD_MNEMONIC,        new Integer(KeyEvent.VK_F) },

		{ ActionResources.HOME_NAME,               "In\u00EDcio" },
		//{ ActionResources.HOME_COMMAND,            "home" },
		{ ActionResources.HOME_SHORTDESC,          "In\u00EDcio" },
		{ ActionResources.HOME_LONGDESC,           "In\u00EDcio" },
		//{ ActionResources.HOME_LARGEICON,          "home24.png" },
		{ ActionResources.HOME_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_HOME, Event.CTRL_MASK) },
		{ ActionResources.HOME_MNEMONIC,           new Integer(KeyEvent.VK_H) },

		{ ActionResources.ANALYZE_NAME,            "Explain Analyze" },
		//{ ActionResources.ANALYZE_COMMAND,         "explain analyze" },
		{ ActionResources.ANALYZE_SHORTDESC,       "Explain Analyze" },
		{ ActionResources.ANALYZE_LONGDESC,        "Explain Analyze" },
		//{ ActionResources.ANALYZE_SMALLICON,       "explain16.png" },
		//{ ActionResources.ANALYZE_LARGEICON,       "explain24.png" },
		{ ActionResources.ANALYZE_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_L, Event.CTRL_MASK) },
		{ ActionResources.ANALYZE_MNEMONIC,        new Integer(KeyEvent.VK_L) },
		{ ActionResources.ANALYZE_MNEMONIC_INDEX,  new Integer(11) },

		{ ActionResources.STOP_NAME,               "Parar" },
		//{ ActionResources.STOP_COMMAND,            "stop" },
		{ ActionResources.STOP_SHORTDESC,          "Parar" },
		{ ActionResources.STOP_LONGDESC,           "Parar" },
		//{ ActionResources.STOP_SMALLICON,          "stop16.png" },
		//{ ActionResources.STOP_LARGEICON,          "stop24.png" },
		{ ActionResources.STOP_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_Z, Event.CTRL_MASK) },
		{ ActionResources.STOP_MNEMONIC,           new Integer(KeyEvent.VK_Z) },

		//{ ActionResources.DEFAULT_NAME,            "Unknown Action" },

	};
}// Resources
