/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.treedisplay;

import java.awt.Graphics;
import javax.swing.tree.TreeSelectionModel;

/**
 * TreeRenderer is the interface that classes that want to draw a
 * TreeDisplay tree should implement. There are two methods that need
 * to be filled in: one to draw nodes ({@link #drawNode drawNode}),
 * and one to draw edges ({@link #drawEdge drawEdge}).
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 0.0
 */
public interface TreeRenderer {
	/**
	 * Draw a node.
	 *
	 * @param node a <code>TreeLayoutNode</code> value
	 * @param g a <code>Graphics</code> value
	 * @param m a <code>TreeSelectionModel</code> value
	 */
	public void drawNode(TreeLayoutNode node, Graphics g, TreeSelectionModel m);

	/**
	 * Draw an edge.
	 *
	 * @param edge a <code>TreeLayoutEdge</code> value
	 * @param g a <code>Graphics</code> value
	 * @param m a <code>TreeSelectionModel</code> value
	 */
	public void drawEdge(TreeLayoutEdge edge, Graphics g, TreeSelectionModel m);
}// TreeRenderer
