\name{setData.ggobi}
\alias{setData.ggobi}
\alias{getData.ggobi}
\title{Load or retrieve a ggobi dataset.}
\description{
\code{getData.ggobi} retrieves the contents of a ggobi dataset
as an S matrix
and  \code{setData.ggobi} adds or replaces
a dataset either from a file or from an R matrix
or data frame.
}
\usage{
setData.ggobi(data, name = deparse(sys.call()[[2]]), ..., .gobi=getDefaultGGobi())
getData.ggobi(.data = 1, .gobi=getDefaultGGobi())
}
\arguments{
  \item{data}{the name of a file or URL from which to load data
   or an S data frame or matrix containing the data.}
  \item{.gobi}{the ggobi instance into which or from which 
    the data should be added or retrieved. }
  \item{name}{the name to use for the dataset in the tab labels or when
    referring to datasets in a GGobi instance from R.}
  \item{.data}{an identifier for the dataset of interest with the GGobi instance.
   This is either a name, an integer index or a reference to a GGobi dataset of
   class \code{ggobiDataset}}
  \item{...}{passed to \code{\link{setDataFile.ggobi}}}
}
\value{
 \code{getData.ggobi}
 returns a matrix containing the values
 in the specified ggobi dataset, using
 its row labels as row names and variable names
 as column names.

 \code{setData.ggobi} returns an object of class
 \code{ggobiDataset} that provides a convenient
 reference to the internal ggobi dataset. 
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}


\seealso{
\code{\link{setDataFrame.ggobi}}
\code{\link{setDataFile.ggobi}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
  data(mtcars)
  setData.ggobi(mtcars)

  getData.ggobi(g[[1]])
  g[[1]][,1]
}
\keyword{iplot}
