// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/interface/jit_export.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

//
// These are the functions that a JIT built as a DLL must export.
//

#ifndef _JIT_EXPORT_H
#define _JIT_EXPORT_H


#include "jit_intf.h"



////////////////////////////////////////////////////////
// Optional functions that don't have to be provided.
////////////////////////////////////////////////////////

// Called once at the end of the constructor.
extern "C"
JITExport void JIT_init(JIT_Handle j);

// Called once at the end of the destructor.
extern "C"
JITExport void JIT_deinit();

extern "C"
JITExport void JIT_next_command_line_argument(const char *name, const char *arg);

extern "C"
JITExport void JIT_gc_start();

extern "C"
JITExport void JIT_gc_end();

extern "C"
JITExport void JIT_gc_object_died(void *java_ref);


////////////////////////////////////////////////////////
// Required functions.
////////////////////////////////////////////////////////

extern "C"
JITExport JIT_Result 
JIT_gen_method_info(Compile_Handle     compilation,              // in
                    Method_Handle      method,                   // in
                    JIT_Flags          flags                     // in
                    );

extern "C"
JITExport JIT_Result 
JIT_compile_method(Compile_Handle     compilation,              // in
                   Method_Handle      method,                   // in
                   JIT_Flags          flags                     // in
                   );

extern "C"
JITExport void
JIT_unwind_stack_frame(Method_Handle       method,               // in
                       Frame_Context      *context,              // in out
                       Boolean             is_first              // in
                       );

extern "C"
JITExport void 
JIT_get_root_set_from_stack_frame(Method_Handle         method,        // in
                                  GC_Enumeration_Handle enum_handle,   // in
                                  Frame_Context        *context,       // in out
                                  Boolean               is_first       // in
                                  );


extern "C"
JITExport Boolean
JIT_can_enumerate(Method_Handle method,
                  uint32        eip
                  );

extern "C"
JITExport unsigned
JIT_num_breakpoints(Method_Handle method,
                    uint32        eip
                    );

extern "C"
JITExport void
JIT_get_breakpoints(Method_Handle method,      // in
                    uint32        *bp,         // out
                    Frame_Context *context     // in out
                    );

extern "C"
JITExport void
JIT_fix_handler_context(Method_Handle      method,                     // in
                        Frame_Context     *context,                    // in out
                        Boolean            is_first                    // in
                        );

extern "C"
JITExport void *
JIT_get_address_of_this(Method_Handle       method,                     // in
                        const Frame_Context *context,                    // in
                        Boolean             is_first                    // in
                        );

extern "C"
JITExport Boolean
JIT_call_returns_a_reference(Method_Handle         method,              // in
                             const Frame_Context  *context              // in
                             );

extern "C"
JITExport int32 
JIT_get_break_point_offset(Compile_Handle compilation,
                           Method_Handle  meth,
                           JIT_Flags      flags,
                           unsigned       bc_location);
extern "C"
JITExport void * 
JIT_get_address_of_var(Frame_Context *context,
                       Boolean       is_first,
                       unsigned      var_no);

#endif // _JIT_EXPORT_H
