// Copyright (C)  2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/bytereader.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//



#ifndef _BYTEREADER_H_
#define _BYTEREADER_H_



#include "orp_types.h"


class ByteReader {
    int offset;
    int len;
    uint8 *start;
    uint8 *end;
    uint8 *curr;
    bool byte_array_owner;
public:
    bool error;
    ByteReader(int _file_handle, int64 _offset, int64 _len);
    ByteReader(uint8 *bytecode, int _offset, int _len);
    ~ByteReader();

    int get_offset();
    void dump(int num_bytes);

    // returns the offset of the next occurence of byte starting at the
    // current offset.  Does not modify the cursor position.
    // Returns -1 if the byte couldn't be found.
    int find_byte(uint8 byte);

    // The following functions return true if there was no error.
    // "_be" suffix means "big endian".
    // "_le" suffix means "little endian".
    bool go_to_offset(int _offset);
    bool skip(int num_bytes);
    bool parse_u4_be(uint32 *val);
    bool parse_u4_le(uint32 *val);
    bool parse_u2_be(uint16 *val);
    bool parse_u2_le(uint16 *val);
    bool parse_u1(uint8 *val);
    bool read_bytes(uint8 *buffer, int len);
}; //ByteReader


#endif
