// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/mrl_gc_v1.h,v 1.8 2002/01/09 14:50:13 weldon Exp $
//


#ifndef _mrl_gc_v1_H_
#define _mrl_gc_v1_H_

//
// Header for the Implementation of the version 1.0 MRL GC with multiple
// generations, large object space, and incremental collection of mature
// object spaces.
//

#include "nursery.h"

#include "gc_for_orp.h"

#include "block_store.h"
#include "card_table.h"
#include "gc_interface.h"
#include "generation.h"
#include "remembered_set.h"
#include "gc_space.h"
#include "los_container.h"

#ifdef ORP_POSIX
#include "linux_api.h"
#endif

#ifdef ORP_NT
#include "Win32_api.h"
#endif

#include "nursery_step_gen.h"
#include "car.h"
#include "train.h"

#define MAXIMUM_GENERATIONS 8

class Car;
//class Directory;
class Gc_Fast_Hooks;
class Gc_Plan;
class Gc_Space;
class LOS_Container;
class Step_Plus_Nursery_Generation;
class Train;

extern bool _collection_in_progress;

    //
    // The remembered set used to store all the live
    // references enumerated by the ORP. The slots
    // must be outside the heap and hold references into
    // the heap.
    //
extern    Root_List *p_root_set;
extern    Root_List *p_verify_root_set;

extern int get_free_non_nursery_block_count ();

extern int get_free_block_count ();

extern int get_total_block_count ();

extern int get_los_block_count ();

#ifdef ORP_POSIX
class Mrl_Gc_V1 : public Gc_Interface, Linux_Api {
#else
class Mrl_Gc_V1 : public Gc_Interface, Win32_Api {
#endif

public:
    Mrl_Gc_V1(ORP_Control *p_orp_control,
              char *p_plan_file_name);

    virtual ~Mrl_Gc_V1();

    //
    // The ORP is forcing a barrier collection:
    //
    void reclaim_heap(unsigned int size, bool forced);
    //
    // The ORP is enumerating a weak reference.
    //
    virtual void gc_add_weak_reference(Java_java_lang_Object **ref) {
        assert (0); // This is code for a better weak ref idea that died when
                    // Java 2 introduced their notion of weak reference. Hayes was right
                    // about weak references, I should have paid attention.
                    // Break and debug, we might want to treat this as a strong reference.
        _p_weak_references->add_entry((Java_java_lang_Object **)ref);
    }
    //
    // The ORP is providing us with yet another live reference.
    // We add it to our root set. This happens at the beginning
    // of a stop-the-world phase, when we call into the ORP
    // to enumerate all live references.
    //
    void gc_add_root_set_entry(Java_java_lang_Object **ref);

    
    virtual Java_java_lang_Object *gc_pinned_malloc(long size,
                                   VTable *p_VTable,
                                   bool return_null_on_fail,
                                   bool double_align
                                   ) {
        return _p_los_container->gc_pinned_malloc(size, 
                                                  p_VTable,
                                                  return_null_on_fail,
                                                  double_align                                            
                                                  );
    }

    virtual Java_java_lang_Object *gc_pinned_malloc_noclass(long size) {
        return _p_los_container->gc_pinned_malloc_noclass(size);
    }
 
    
    void *gc_large_malloc(long size,
                          VTable *p_VTable) {
        //
        // Currently we just call pinned blindly. 
        // 'Large' doesn't imply 'pinned'.
        // May want to add heuristics here.
        //
        return _p_los_container->gc_pinned_malloc(size, 
                                                  p_VTable,
                                                  false,
                                                  false
                                                  );
    }

 

    void free(Java_java_lang_Object *p_obj);

    //
    // An older generation is telling us that it has discovered a
    // reference to a younger generation in the process of importing
    // an object. 
    //
    void notify_new_old_to_young_reference(Java_java_lang_Object **pp_obj_ref);

    //
    // This method is called during system exit if the application
    // requested this feature.
    //
    void run_all_finalizers();


    //
    // The ORP is passing on to the GC the verbosity level that
    // the user has specified on the command line.
    //
    void set_verbose_level(unsigned int level);
    //
    // Subsequent to a freeze, the mutator is now 
    // telling us that all is clear.
    //
    void thaw() {
        orp_resume_threads_after(false);
    }

    //
    // ORP notification to GC to clean up.
    //
    virtual void wrapup_gc();

    // The Mrl_Gc_V1 sets up and maintains a focus car which is usually nil or the
    // oldest car in the oldest train... If Nil then no collection of a car is going on.
    Car *p_get_focus_car();

    Train *p_get_focus_train();

#ifdef OBJECT_SPLITTING
	int get_large_nursery_size()
	{
		// Return the size of the large nursery.
		return _p_gc_plan->large_nursery_block_size_bytes();
	}
#endif // OBJECT_SPLITTING

private:

    Mrl_Gc_V1();

    //
    // The block store manages free blocks which are the basic
    // units of storage used by cars, nurseries, steps, etc...
    //
    Block_Store *_p_block_store;

    //
    // The card table is used for card marking write barriers.
    //
    Card_Table  *_p_card_table;

    //
    // The plan object contains the various GC size parameters.
    //
    Gc_Plan            *_p_gc_plan;

    //
    // Routine to ask the ORP for all live references.
    //
    void _get_orp_live_references();
    void enumerate_weak_reference_queues ();

    //
    // The LOS holds objects too big (hence expensive) to move,
    // or which can't move due to their being position dependent.
    //
    LOS_Container *_p_los_container;

    //
    // The mature generation which is implemented using a train.
    //
    Train_Generation *_p_mature_generation;
    //
    // The remembered set used to store all the live
    // references enumerated by the ORP. The slots
    // must be outside the heap and hold references into
    // the heap.
    //
//    Root_List *p_root_set;
//    Root_List *p_verify_root_set;

    //
    // The remembered set used to store all the weak
    // references enumerated by the ORP.
    //
    Remembered_Set *_p_weak_references;

    // There are three Remembered Sets that need to be maintained for
    // the train algorithm. Since the other algorithms are just subsets
    // of the train algorithm these sets also work for them.

    Remembered_Set *_p_refs_to_young_object_space;
    Remembered_Set *_p_refs_to_focus_car;
//    Remembered_Set *_p_refs_to_focus_car_from_focus_train;
    bool ref_to_focus_train_exists;

    Car *_p_focus_car;
    Train *_p_focus_train;

 //   unsigned int _car_size_car_blocks;    
    unsigned long _card_size_bytes;

    //
    // After a stop-the-world collection, give all
    // generations an opportunity to clean up and
    // then re-start the ORP.
    //
    void resume_orp();

    void Mrl_Gc_V1::_execute_collection();

    //
    // This private method is called during the creation of the
    // Mrl_Gc_V1 object in order to set up the hooks and 
    // create the plan object.
    //
    void _initialize_plan_and_hooks(char *p_plan_file_name);

    //
    // The hooks object is used for performance measurement and
    // debugging.
    //
    Gc_Fast_Hooks *_p_gc_hooks;

    unsigned short _maximum_number_of_generations;

    //
    // Number of generations in this GC implementation.
    //
    unsigned int _number_of_generations;

};

#endif // _MRL_GC_V1_H_
