// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/gc_consts.h,v 1.1 2001/09/14 18:01:59 rlhudson Exp $
//

#ifndef _gc_consts_H_
#define _gc_consts_H_


//
// Any constants defined in the GC
//


#include "platform.h"

//
// WARNING WARNING WARNING WARNING WARNING WARNING
// All this stuff is temporary and needs to be flushed
// when we have the plan file mechanism.
//

#ifdef SPACE_DEMOGRAPHICS
#define DEMOGRAPHICS_ARRAY_SIZE 3200000
//1048576

#endif

//
// A lot of code needs to do a quick shift of an address and
// index a table to determine what generation the address is in.
// While the encoding for objects in the trains is more complex
// the YOS encoding will always be 0 for fast checks.
//

#define YOS_GEN_NUMBER 0

// We do not define MOS_GEN_NUMBER since the encoding of the train and
// the car will result in any number except 0.

//
// The default size of object lists (which are currently used
// for keeping track of finalizable objects.)
//
#define DEFAULT_OBJECT_SIZE_IN_ENTRIES 1024

//
// This is the maximum number of LOS segments that can 
// exist.
//
#define MAXIMUM_LOS_SEGMENTS 32

//
// Need to use a vector container instead: HACK HACK HACK.
// WARNING - CANNOT LIMIT NUMBER OF CARS IN A TRAIN.
//
#define MAXIMUM_CARS 1024

#if (GC_DEBUG>1)
//
// When calculating object demographics, we set a cap
// on the maximum # of collections (NEED TO USE A VECTOR!)
//
#define MAXIMUM_COLLECTIONS 4096
#endif

//
// Any objects exceeding this in size are placed in the LOS.
//
// OLD: see gc_plan: #define LARGE_OBJECT_THRESHOLD_IN_BYTES  1024


#define MAXIMUM_NURSERIES 5192

//
// The number of nurseries to add when we run out.
//
#define NURSERY_INCREMENT 100

//
// Number of blocks to add when we run out of blocks.
//
#define EXTENSION_INCREMENT 32
//
// The maximum number of blocks there can be in a block list:
// NOTE - NEED TO FIX THIS BY USING VECTORs INSTEAD.
//



#define MAXIMUM_BLOCKS_IN_LIST 32768

//
// Need to move this to a plan file, or convert into a
// template-based dynamic array.
//
#define MAXIMUM_LOSES_IN_LOS_CONTAINER 4096

#endif // _gc_consts_H_

