// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/block_list.h,v 1.7 2001/12/05 21:58:57 rlhudson Exp $
//


#ifndef _block_list_H_
#define _block_list_H_

#include "platform.h"
#include "gc_hooks.h"
#include "gc_header.h"
#include "remembered_set.h"
#include "block_store.h"
#include "generation.h"
#include "descendents.h"

#include "gc_space.h"
#include "gc_consts.h"

class Card_Table;
class Gc_Fast_Hooks;
class Gc_Plan;

Java_java_lang_Object *p_get_forwarded_object (block_info *block_info, Java_java_lang_Object *p_obj);
void scan_object(Java_java_lang_Object *p_object);
train_info *get_youngest_train ();

class Block_List : public Gc_Space {
public:
    //
    // Create a step (done by Step_Plus_Nursery_Generation).
    //
    Block_List(unsigned long space_id,
        Gc_Fast_Hooks *p_gc_hooks,
        Gc_Plan       *p_gc_plan,
        Generation    *p_container,
        Gc_Space      *p_superior,
        Card_Table    *p_card_table,
        Block_Store   *p_block_store)
        
        : Gc_Space(space_id, 
        p_gc_hooks,
        p_gc_plan,
        p_container, 
        p_superior, 
        p_card_table,
        p_block_store)	{
        
        _number_of_blocks        = 0;
        
        assert(sizeof(_current_block_id) == 4);
        _current_block_id = 0xFFFFFFFF;
    }
    
    //
    // Deletion is child space-specific.
    //
    virtual ~Block_List() {
        assert(0);
    }

    //
    // The most important thing in a block list is a list of blocks. Here is the head of that list.
    // Any information that is critical to performance is held in the block_info.
    //

    block_info *blocks;
    
    // Check if this space owns this block
    bool debug_owns_block(void *p_block)
    {
        for (unsigned int idx = 0; idx < _number_of_blocks; idx++) {
            if (p_block == _p_block[idx]) {
                return true;
            }
        }
        return false;
    }
    
    //
    // Should use inspect instead.
    //
    //
    // At debug time, when a car has been reclaimed, or when
    // the FROM blocks are being reclaimed, we may choose to
    // avoid re-using the blocks, instead marking them as
    // in an obsolete container.
    //
    void debug_set_blocks_obsolete();
    void debug_write_protect_blocks();
    //
    // Do any required cleanup at the end of the collection.
    //
    virtual void cleanup();
    
    //
    // Walk the entire list in the container and apply the function header.
    //
    void walk_list(bool (*func)(Object_Gc_Header *,
        Remembered_Set *));
    
    
protected:
    
    //
    // The following routine should be implemented by all containers
    // that implement block lists. The value returned by the container
    // reflects a generation encoding, which is used by the block list
    // object for marking all sub blocks in the block store. This is
    // used later for doing fast checks of generations.
    //
    virtual unsigned long _get_generation_encoding() = YOS_GEN_NUMBER;
    
    
    Block_List();
    
    //
    // Identifies current block being cheney scanned.
    //
    unsigned long _current_block_id;
    
    //
    // Number of blocks in this list.
    //
    unsigned long _number_of_blocks;

    block_info *_first_block;
    block_info *_last_block;
    // The block list code includes scanners that are common to card scanning and cheney scanning.
    //    These include _scan_object and _scan_array where this is the block list with the 
    //    slot in it and the target block info (or block list) would be determined by looking
    //    at the target of the slot.
        
    void *_p_block[MAXIMUM_BLOCKS_IN_LIST];
    Object_Gc_Header *_p_block_end[MAXIMUM_BLOCKS_IN_LIST];
    
    //
    // Verify all objects in specified block are consistent.
    //
    bool _verify_block(void *p_block_start,
        void *p_block_end);
};



#endif // _block_list_H_

