// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/generation.cpp,v 1.4 2002/01/09 14:50:13 weldon Exp $
//

#include "card_table.h"
#include "remembered_set.h"
#include "generation.h"
#include "gc_interface.h"
#include "gc_plan.h"
#include "gc_hooks.h"
#include "block_store.h"
#include "nursery_step_gen.h"
#include "train_generation.h"

Generation::Generation(unsigned long generation_number,
                       Gc_Fast_Hooks *p_gc_hooks,
                       Gc_Plan       *p_gc_plan,
		               Gc_Interface  *p_container,
			           Generation    *p_superior,
                       Card_Table    *p_card_table,
		               Block_Store   *p_block_store) 

                       : Gc_Component(p_gc_hooks,
                                      p_gc_plan,
                                      p_block_store)
{

    _p_gc_plan             = p_gc_plan;
	_p_block_store         = p_block_store;
	_p_card_table          = p_card_table;
	_p_container           = p_container;
	_p_superior_generation = p_superior;
	_generation_number     = generation_number;

	//
	// Initialize the variable that will record which GC
	// space is being scanned, so that we can avoid recursively
	// doing cheney scans, or requesting unnecessary scans.
	//
	_p_space_being_scanned = NULL;
    //
    // Container for young-to-old references discovered
    // during reclamation of this generation.
    //
    // This is used when collecting a step/nursery generation but not when
    // collecting the MOS (train).
    //
    _p_young_to_old_rs = new Remembered_Set();
    return;
}	



// end file generation.cpp

