// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/gc_walk.cpp,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

 
#include "gc_for_orp.h"
 

#include "platform.h"
#include "gc_perf.h"
#include "nursery.h"
#include "step.h"
#include "car.h"
#include "train.h"

 

bool _verify_array_object_references_in_rs(Object_Gc_Header *p_gc_hdr,
                                            Remembered_Set   *p_rs)
{
    Java_java_lang_Object *p_obj =
        get_object_from_gc_header(p_gc_hdr);

    Partial_Reveal_Class *p_class = (*((Partial_Reveal_VTable **)p_obj))->clss;
    // delete Partial_Reveal_Class *p_class = get_object_class(p_obj);

    bool array_p = is_array(p_class);
    
    assert (array_p);
    
    Generation *p_gen = 
        p_global_bs->p_get_object_generation(p_obj);

    // If array is an array of primitives, then there are no references, so return.
    if (is_array_of_primitives(p_class))
        return true;

    unsigned int offset_scanner = init_array_scanner (p_obj);

    Java_java_lang_Object **pp_child_ref;

	while ((pp_child_ref = p_get_array_ref(p_obj, offset_scanner)) != NULL) {
        
        // ignore NULL in the slot
        if (*pp_child_ref==NULL) {
            continue;
        }
        // Move the scanner to the next reference.
        offset_scanner = next_array_ref (offset_scanner);

       Java_java_lang_Object *p_child = *pp_child_ref;

       Generation *p_child_gen = 
		   p_global_bs->p_get_object_generation(p_child);

    	if (p_child_gen->is_step_plus_nursery_generation()) {

            if (p_rs->is_not_present(pp_child_ref)) {
                cerr << "Error: discovered unrecorded old-to-young pointer";
                cerr << endl;
                assert(0);
                orp_exit(1);
            }
        }
    }
    return true;
}

//
// The following routine is used by walkers in mature space to
// look for old-to-young pointers that are not properly recorded.
//
// This routine takes an object header and a remembered set and
// ensures that all references in that object that are from old
// to young are recorded in the remembered set.
//
bool verify_old_to_young_reference_is_in_rs(Object_Gc_Header *p_gc_hdr,
                                            Remembered_Set   *p_rs)
{
    Java_java_lang_Object *p_obj =
        get_object_from_gc_header(p_gc_hdr);

    Partial_Reveal_Class *p_class = (*((Partial_Reveal_VTable **)p_obj))->clss;
    //delete    Partial_Reveal_Class *p_class = get_object_class(p_obj);

    bool array_p = is_array(p_class);
    
    if (array_p) {
        return _verify_array_object_references_in_rs (p_gc_hdr, p_rs);
    }
    Generation *p_gen = 
        p_global_bs->p_get_object_generation(p_obj);

    unsigned int *offset_scanner = init_object_scanner (p_obj);

    Java_java_lang_Object **pp_child_ref;

	while ((pp_child_ref = p_get_ref(offset_scanner, p_obj)) != NULL) {
        
        // ignore NULL in the slot
        if (*pp_child_ref==NULL) {
            continue;
        }
        // Move the scanner to the next reference.
        offset_scanner = p_next_ref (offset_scanner);

       Java_java_lang_Object *p_child = *pp_child_ref;

       Generation *p_child_gen = 
		   p_global_bs->p_get_object_generation(p_child);

    	if (p_child_gen->is_step_plus_nursery_generation()) {

            if (p_rs->is_not_present(pp_child_ref)) {
                cerr << "Error: discovered unrecorded old-to-young pointer";
                cerr << endl;
                assert(0);
                orp_exit(1);
            }
        }
    }
    return true;
}


 
#ifdef CLASS_DEMOGRAPHICS 
bool walk_report_dead_object(Object_Gc_Header *p_hdr, Remembered_Set   *p_rs)
{

    Java_java_lang_Object *p_obj = get_object_from_gc_header(p_hdr);

    if (is_object_unmarked(p_obj)) {
        delete_for_class_demographics(p_obj->vt);
    }

    return true;
}
#endif

// end file gc\gc_walk.cpp

