// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/gc_asserts.cpp,v 1.1.1.1 2001/07/23 07:25:38 xli18 Exp $
//

#if (GC_DEBUG>3)
#include "gc_header.h"
#include "descendents.h"

//
// This routine is fed to the walk routines to ensure that none of the
// live objects after a scavenge have their forward bits set.
//
bool
assert_object_not_forwarded(Object_Gc_Header *p_gc_hdr,
							Remembered_Set *p_rs)
{
	assert((*p_gc_hdr & 0x1) == 0);
	Java_java_lang_Object *p_obj = get_object_from_gc_header(p_gc_hdr);
	//Descendents *p_desc = new Descendents(p_obj);
	// INCOMPLETE
	return true;
}


//
// This routine is fed to the walk routines after a scavenge
// to check for dead objects that have lock bits set.
bool
assert_object_not_locked(Object_Gc_Header *p_gc_hdr)
{
	if (is_object_forwarded(p_gc_hdr)) {
		//
		// It is still live, since the scavenge forwarded it.
		//
		return true;
	}

	assert((*p_gc_hdr & BUSY_FORWARDING_BIT) == 0);
	return true;
}

//
// This routine is fed to the walk routines before a stop-the-world
// scavenge to ensure that none of the objects are busy. The ORP
// should have ensured this before enumerating live references.
// If set, there could be inconsistencies, since the ORP thread code
// and the GC are concurrently accessing that object.
//
bool
assert_busy_bit_not_set(Object_Gc_Header *p_gc_hdr,
						Remembered_Set *p_rs)
{
	assert((*p_gc_hdr & BUSY_FORWARDING_BIT) == 0);
	return true;
}

bool
assert_is_object(Object_Gc_Header *p_gc_hdr,
				 Remembered_Set *p_rs)
{
    if (verify_is_object(p_gc_hdr)) {
        return true;
    } else {
        assert(0);
        return false;
    }
}

bool
assert_reachable_objects_in_array_not_forwarded(Object_Gc_Header *p_gc_hdr,
									   Remembered_Set *p_rs)
{
    Java_java_lang_Object *p_object =
        get_object_from_gc_header(p_gc_hdr);

    Partial_Reveal_Class *p_class = get_object_class(p_object);

    // If array is an array of primitives, then there are no references, so return.
    if (is_array_of_primitives(p_class))
        return;

    // Initialize the array scanner which will scan the array from the
    // top to the bottom. IE from the last element to the first element.
    unsigned int offset = init_array_scanner (p_object);
	// Cycle through all the descendents.
    Java_java_lang_Object **pp_target_object;
	while ((pp_target_object = p_get_array_ref(p_object, offset)) != NULL) {
        offset = next_array_ref (offset);
        if (*pp_target_object == NULL) {
            continue;
        }
        Object_Gc_Header *p_child_gc_header =
            get_object_gc_header(*pp_target_object);

        assert_object_not_forwarded(p_child_gc_header, NULL);
    }
    return true;
}
//
// Verify that valid objects don't refer to obsolete objects.
//
bool
assert_reachable_objects_not_forwarded(Object_Gc_Header *p_gc_hdr,
									   Remembered_Set *p_rs)
{
    Java_java_lang_Object *p_object =
        get_object_from_gc_header(p_gc_hdr);
    Partial_Reveal_Class *p_class = get_object_class(p_object);
    bool array_p = is_array(p_class);
    if (array_p) {
        return assert_reachable_objects_in_array_not_forwarded(p_gc_hdr,
                                                               p_rs);
        return true;
    }
    unsigned int *offset_scanner = init_object_scanner (p_object);
    Java_java_lang_Object **pp_target_object;
	while ((pp_target_object = p_get_ref(offset_scanner, p_object)) != NULL) {
        // Move the scanner to the next reference.
        offset_scanner = p_next_ref (offset_scanner);
        // ignore NULL
        if (*pp_target_object==NULL) {
            continue;
        }
        
        Object_Gc_Header *p_child_gc_header =
            get_object_gc_header(*pp_target_object);

        assert_object_not_forwarded(p_child_gc_header, NULL);
    }
    return true;
}



#endif // _DEBUG

// end file gc\gc_asserts.cpp
