// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/class_loader/Arena.cpp,v 1.1.1.1 2001/07/23 07:25:38 xli18 Exp $
//


#include "platform.h"
#include <malloc.h>
#include <stdlib.h>
#include "Arena.h"

#ifdef USE_IA64_JIT
#define BITS_TO_CLEAR 7
#else
#define BITS_TO_CLEAR 3 
#endif


Arena	*init_arena(void *space,Arena *next_arena,unsigned size)
{
    // memory should be aligned
    assert(((unsigned)space  & BITS_TO_CLEAR) == 0);
    Arena *arena = (Arena *)space;
	arena->next_arena = next_arena;
	arena->next_byte = arena->bytes;
	arena->last_byte = arena->bytes + size;
	return arena;
}


Arena	*alloc_arena(Arena *next,unsigned size)
{
	//
	// malloc a chunk of memory for a new arena
	// we add space for 3 pointers - the arena's next and end fields and next arena
	// make sure it is rounded up or else space will be wasted 
    // and unneccesssary reallocs will occur
    
    size = (size + BITS_TO_CLEAR) & ~BITS_TO_CLEAR;
    unsigned header_size = (sizeof(struct Arena *)+sizeof(char *)+sizeof(char *) + BITS_TO_CLEAR) 
                            & ~BITS_TO_CLEAR;
    return init_arena(malloc(size + header_size),next,size);
}

void	free_arena(Arena *a)
{
	free(a);
}

void *arena_alloc_space(Arena *arena,unsigned size)
{
	if (size == 0)
		return NULL;
    
    assert(((unsigned)arena->next_byte & BITS_TO_CLEAR) == 0);
    size = (size + BITS_TO_CLEAR) & ~BITS_TO_CLEAR;

	if (arena->next_byte + size > arena->last_byte) {
		// not enough space
		return NULL;
	}
	// return the space and bump next_byte pointer
	char *mem = arena->next_byte;
	arena->next_byte += size;
    assert (arena->next_byte <= arena->last_byte);
	return (void*)mem;
}




