// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_lang_Object.cpp,v 1.5 2002/01/07 02:17:01 gwu2 Exp $
//


#include "platform.h"
#include <assert.h>
#include <iostream.h>

#include "native_utils.h"

#include "orp_types.h"
#include "Class.h"
#include "stack_manipulation.h"
#include "exceptions.h"
#include "environment.h"
#include "object_layout.h"
#include "orp_threads.h"
#include "nogc.h"
#include "root_set_enum.h"
#include "orp_utils.h"
#include "orp_synch.h"
#include "sync_bits.h"
#include "java_lang_Thread.h"

#include "java_lang_Object.h"
#include "java_lang_VMObject.h"

#ifdef OBJECT_LOCK_V2
#include "object_generic_olv2.h"
#else
#include "object_generic.h"
#endif

#include "orp_stats.h"

#include "gnu_classpath_jni_utils.h"

#ifdef OBJECT_SPLITTING
#include "gc_interface.h"
#endif // OBJECT_SPLITTING


#ifdef ORP_POSIX
#include "platform2.h"
#ifdef __linux__
#include <asm/bitops.h>
#endif
#endif


///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: start_of_object_busybit_critical_zone() MUST BE  THE FIRST
///////////////
/////////////// PROCEDURE IN java_lang_Object.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////

void start_of_object_busybit_critical_zone()
{
////////////// THIS MUST BE THE FIRST PROCEDURE IN java_lang_Object.cpp
////////////// SEE in_busybit_critical_zone() for details
}


long busy_bit_debug_counter = 0;


// the address_of... below gets around vc++ __asm problem where
// a "call setup_java_to_native_frame" is relative and I need
// an absolute address since the code is copied/relocated by 
// orp_monitor_singlethread()/multithread()
uint32 address_of_setup_java_to_native_frame;
uint32 address_of_orp_monitor_enter;
uint32 address_of_pop_java_to_native_frame;
uint32 address_of_orp_monitor_exit;


///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: end_of_object_busybit_critical_zone() MUST BE  THE LAST
///////////////
/////////////// PROCEDURE IN java_lang_Object.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////

void end_of_object_busybit_critical_zone()
{
////////////// THIS MUST BE THE LAST PROCEDURE IN java_lang_Object.cpp
////////////// SEE in_busybit_critical_zone() for details
}

 


///8888888888888888888888888888888888888888888888888**************************
///8888888888888888888888888888888888888888888888888**************************
///8888888888888888888888888888888888888888888888888**************************
///8888888888888888888888888888888888888888888888888**************************



#define NEW_ARRAY(X) new_arr = jenv->New##X##Array(length); assert(new_arr);		

#define GET_ARRAY_ELEMENTS(X, Y) src_bytes = jenv->Get##X##ArrayElements((j##Y##Array)jobj, &is_copy); \
	dst_bytes = jenv->Get##X##ArrayElements((j##Y##Array)new_arr, &is_copy);

#define MEMCPY(X) orp_disable_gc(); memcpy(dst_bytes, src_bytes, sizeof(j##X) * length); orp_enable_gc();

#define RELEASE_ARRAY_ELEMENTS(X, Y) jenv->Release##X##ArrayElements((j##Y##Array)new_arr, (j##Y *) dst_bytes, 0); \
	jenv->Release##X##ArrayElements((j##Y##Array)jobj, (j##Y *)src_bytes, JNI_ABORT);

#define HANDLE_TYPE_COPY(A, B) NEW_ARRAY(A) GET_ARRAY_ELEMENTS(A, B) MEMCPY(B) RELEASE_ARRAY_ELEMENTS(A, B)




/*
 * Class:     java_lang_Object
 * Method:    clone
 * Signature: ()Ljava/lang/Object;
 */


JNIEXPORT jobject JNICALL Java_java_lang_VMObject_clone
 //(JNIEnv *jenv, jobject jobj)
   (JNIEnv *jenv, jclass unused_parameter, jobject jobj)

{
	if(!jobj || IsNullRef(jobj)) {
		// Throw NullPointerException.
		throw_exception_from_jni(jenv, "java/lang/NullPointerException", 0);
	}

	jclass object_class = jenv->GetObjectClass(jobj);
	assert(object_class);

	// Determine if the object class is of array type.
	jclass class_class = jenv->FindClass("java/lang/Class");
	assert(class_class);
	jmethodID isarray_meth = jenv->GetMethodID(class_class, "isArray", "()Z");
	jboolean is_array = jenv->CallBooleanMethod(object_class, isarray_meth);
	jenv->DeleteLocalRef(class_class);

	if (is_array) {

		// First determine the length of the array.
		jsize length = jenv->GetArrayLength((jarray)jobj);

		jclass array_of_byte_class =	jenv->FindClass("[B"); assert(array_of_byte_class);
		jclass array_of_boolean_class = jenv->FindClass("[Z"); assert(array_of_boolean_class);
		jclass array_of_char_class =	jenv->FindClass("[C"); assert(array_of_char_class);
		jclass array_of_int_class =		jenv->FindClass("[I"); assert(array_of_int_class);
		jclass array_of_long_class =	jenv->FindClass("[J"); assert(array_of_long_class);
		jclass array_of_float_class =	jenv->FindClass("[F"); assert(array_of_float_class);
		jclass array_of_double_class =	jenv->FindClass("[D"); assert(array_of_double_class);

		void *src_bytes, *dst_bytes;

		jboolean is_copy;
		jarray new_arr;

		if (jenv->IsInstanceOf(jobj, array_of_byte_class)) {
			HANDLE_TYPE_COPY(Byte, byte)
		} else if (jenv->IsInstanceOf(jobj, array_of_boolean_class)) {
			// Create a new boolean array and copy the elements.
			HANDLE_TYPE_COPY(Boolean, boolean)
		} else if (jenv->IsInstanceOf(jobj, array_of_char_class)) {
			// Create a new char array and copy the elements.
			HANDLE_TYPE_COPY(Char, char)
		} else if (jenv->IsInstanceOf(jobj, array_of_int_class)) {
			// Create a new integer array and copy the elements.
			HANDLE_TYPE_COPY(Int, int)
		} else if (jenv->IsInstanceOf(jobj, array_of_long_class)) {
			// Create a new long array and copy the elements.
			HANDLE_TYPE_COPY(Long, long)
		} else if (jenv->IsInstanceOf(jobj, array_of_float_class)) {
			// Create a new float array and copy the elements.
			HANDLE_TYPE_COPY(Float, float)
		} else if (jenv->IsInstanceOf(jobj, array_of_double_class)) {
			// Create a new double array and copy the elements.
			HANDLE_TYPE_COPY(Double, double)
		} else {
			// Has to be an array of objects....Need to find a good assert here.
			jclass comp_class = GetClassComponentType(jenv, object_class);
			new_arr = jenv->NewObjectArray(length, comp_class, 0);
			assert(new_arr);
			for (int i = 0; i < length; i++) {
				// Get each reference from the source array and set the approp. dest.
				jobject index_jobj = jenv->GetObjectArrayElement((jobjectArray)jobj, i);
				//assert(index_jobj);
				jenv->SetObjectArrayElement((jobjectArray) new_arr, i, index_jobj);
				jenv->DeleteLocalRef(index_jobj);
			}
		}
	    return new_arr;

    } else {
		// The object is not an array.
		// Check if the interface Cloneable is implemented.
		jclass cloneable_class = jenv->FindClass("java/lang/Cloneable");
		
		if (!(jenv->IsInstanceOf(jobj, cloneable_class))) {
			// Throw exception.
			throw_exception_from_jni(jenv, "java/lang/CloneNotSupportedException", 0);
            return 0;
		}
		jenv->DeleteLocalRef(cloneable_class);

		// Now create a new object of the same class.
		jobject new_object = jenv->AllocObject(object_class);
		assert(new_object);

		// The following code needs to be reviewed - I am exposing the object layout here
		// Should we disable GC during the entire copy??
        // RLH - where have all the write barriers gone???
        orp_disable_gc(); //------------v-----------

		volatile Java_java_lang_Object *src = ((Object_Handle_Struct *)jobj)->java_reference;
		volatile Java_java_lang_Object *dst = ((Object_Handle_Struct *)new_object)->java_reference;

#ifdef OBJECT_SPLITTING
		// Not supported for now.
		assert(0);
#else
		Class *clss = (Class *) (((Object_Handle_Struct *)object_class)->java_reference);
		memcpy((void *)dst, (void *) src, clss->unpadded_instance_data_size);
#ifdef OBJECT_LOCK_V2
		// here should initialize obj_info to zero or clear all parts except hash part.
		*P_OBJ_INFO(dst) = 0;
#endif
#endif

        orp_enable_gc();  //------------^-----------

		return new_object;
	}
}


/*
 * Class:     java_lang_Object
 * Method:    getClass
 * Signature: ()Ljava/lang/Class;
 */

 
JNIEXPORT jclass JNICALL Java_java_lang_Object_getClass
  (JNIEnv *jenv, jobject jobj)
{
	return jenv->GetObjectClass(jobj);
} // Java_java_lang_Object_getClass

/*
 * Class:     java_lang_VMObject
 * Method:    getClass
 * Signature: ()Ljava/lang/Class;
 */

JNIEXPORT jclass JNICALL Java_java_lang_VMObject_getClass
  (JNIEnv *jenv, jclass unused_parameter, jobject jobj)
{
 	return jenv->GetObjectClass(jobj);
} // Java_java_lang_VMObject_getClass

/*
 * Class:     java_lang_Object
 * Method:    hashCode
 * Signature: ()I
 */

JNIEXPORT jint JNICALL Java_java_lang_Object_hashCode
  (JNIEnv *jenv, jobject jobj)
{
	Object_Handle h = (Object_Handle)jobj;
    
	Java_java_lang_Object *p_obj = h->java_reference;

    if (!p_obj) return 0;
        return (jint) generic_hashcode(p_obj);

} // Java_java_lang_Object_hashCode


void java_lang_VMObject_registerNatives (Java_java_lang_Object *clss, Java_java_lang_Object *obj)
{
        // nop for now --> void java_lang_Object_registerNatives(Java_java_lang_Object *)
}


void java_lang_VMObject_notify (Java_java_lang_Object *clss, Java_java_lang_Object *obj)
{
    java_lang_Object_notify(obj);
}

void java_lang_VMObject_notifyAll (Java_java_lang_Object *clss, Java_java_lang_Object *obj)
{
    java_lang_Object_notifyAll(obj);
}

void java_lang_VMObject_wait (Java_java_lang_Object *clss, Java_java_lang_Object *obj, int64 msec)
{
    java_lang_Object_wait(obj, msec);
}
