// Copyright (C)  2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_io_ObjectOutputStream.cpp,v 1.3 2001/08/17 03:09:32 gwu2 Exp $
//

#ifdef ORP_POSIX
#include <unistd.h>
#endif

#include "platform.h"
#include <assert.h>
#include "object_layout.h"
#include "orp_utils.h"
#include "exceptions.h"
#include "jni.h"

#include <sys/types.h>
#include <sys/stat.h>

#ifdef ORP_NT
#include <io.h>
#endif

#include "native_utils.h"
#include "jni_direct.h"
#include "jni_utils.h"
#include "object_layout.h"

#include <fcntl.h>

#ifdef ORP_NT
#include <direct.h>
#endif

#include <errno.h>
#include "VMSystem.h"
#include "java_io_ObjectOutputStream.h"
#include "environment.h"

/*
 * Class:     java_io_ObjectOutputStream
 * Method:    callWriteMethod
 * Signature: (Ljava/lang/Object;)V
 */
JNIEXPORT void JNICALL Java_java_io_ObjectOutputStream_callWriteMethod
  (JNIEnv *jenv, jobject p_this, jobject obj)
{
	jclass clazz = GetObjectClass(jenv, obj);
	jmethodID method_id = GetMethodID(jenv, 
									clazz,
									"writeObject",
									"(Ljava/io/ObjectOutputStream;)V" );
  
	if(!method_id)return;
  
	CallNonvirtualVoidMethod(jenv, obj, clazz, method_id, p_this);
}

/*
 * Class:     java_io_ObjectOutputStream
 * Method:    getBooleanField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_java_io_ObjectOutputStream_getBooleanField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "Z");
	if(!fieldid)return 0;

	jenv->ReleaseStringUTFChars(field_name, fname);

	return GetBooleanField(jenv, obj, fieldid);
}

/*
 * Class:     java_io_ObjectOutputStream
 * Method:    getByteField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;)B
 */
JNIEXPORT jbyte JNICALL Java_java_io_ObjectOutputStream_getByteField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "B");
	if(!fieldid)return 0;

	jenv->ReleaseStringUTFChars(field_name, fname);

	return GetByteField(jenv, obj, fieldid);
}

/*
 * Class:     java_io_ObjectOutputStream
 * Method:    getCharField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;)C
 */
JNIEXPORT jchar JNICALL Java_java_io_ObjectOutputStream_getCharField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "C");
	if(!fieldid)return 0;

	jenv->ReleaseStringUTFChars(field_name, fname);

	return GetCharField(jenv, obj, fieldid);
}

/*
 * Class:     java_io_ObjectOutputStream
 * Method:    getDoubleField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;)D
 */
JNIEXPORT jdouble JNICALL Java_java_io_ObjectOutputStream_getDoubleField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "D");
	if(!fieldid)return 0;

	jenv->ReleaseStringUTFChars(field_name, fname);

	return GetDoubleField(jenv, obj, fieldid);
}

/*
 * Class:     java_io_ObjectOutputStream
 * Method:    getFloatField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;)F
 */
JNIEXPORT jfloat JNICALL Java_java_io_ObjectOutputStream_getFloatField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "F");
	if(!fieldid)return 0;

	jenv->ReleaseStringUTFChars(field_name, fname);

	return GetFloatField(jenv, obj, fieldid);
}

/*
 * Class:     java_io_ObjectOutputStream
 * Method:    getIntField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_java_io_ObjectOutputStream_getIntField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "I");
	if(!fieldid)return 0;

	jenv->ReleaseStringUTFChars(field_name, fname);

	return GetIntField(jenv, obj, fieldid);
}

/*
 * Class:     java_io_ObjectOutputStream
 * Method:    getLongField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;)J
 */
JNIEXPORT jlong JNICALL Java_java_io_ObjectOutputStream_getLongField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "J");
	if(!fieldid)return 0;

	jenv->ReleaseStringUTFChars(field_name, fname);

	return GetLongField(jenv, obj, fieldid);
}

/*
 * Class:     java_io_ObjectOutputStream
 * Method:    getObjectField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;
 */
JNIEXPORT jobject JNICALL Java_java_io_ObjectOutputStream_getObjectField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name, jstring type_code)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);
	const char* tsig = jenv->GetStringUTFChars(type_code, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, tsig);
	if(!fieldid)return NULL;

	jenv->ReleaseStringUTFChars(field_name, fname);
	jenv->ReleaseStringUTFChars(type_code, tsig);

	return GetObjectField(jenv, obj, fieldid);
}

/*
 * Class:     java_io_ObjectOutputStream
 * Method:    getShortField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;)S
 */
JNIEXPORT jshort JNICALL Java_java_io_ObjectOutputStream_getShortField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "S");
	if(!fieldid)return 0;

	jenv->ReleaseStringUTFChars(field_name, fname);

	return GetShortField(jenv, obj, fieldid);
}