// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/common_olv2/thread_generic.cpp,v 1.27 2002/01/11 11:31:48 xli18 Exp $
//

#ifdef OBJECT_LOCK_V2
#include "platform.h"
#include <assert.h>
#include <iostream.h>

#ifndef ORP_POSIX
#include "orp_process.h"
#endif

#include "environment.h"
#include "orp_types.h"
#include "orp_utils.h"
#include "object_layout.h"
#include "Class.h"
#include "orp_threads.h"
#include "nogc.h"
#include "root_set_enum.h"
#include "ini.h"
#include "stack_manipulation.h"
#include "exceptions.h"
#include "jit_intf.h"
#include "orp_synch.h"
#include "exception_filter.h"
#include "orp_threads.h"


#include "enum_trampoline.h"
#include "sync_bits.h"
#include "orp_stats.h"

#ifdef ORP_NT
// wjw -- following lines needs to be generic for all OSs
#include "java_lang_thread_nt.h"
#endif

#ifdef POINTER64
#include "java_lang_thread_ia64.h"
#else
#include "java_lang_thread_ia32.h"
#endif

#include "thread_manager_olv2.h"
#include "object_generic_olv2.h"
#include "thread_generic_olv2.h"
#include "mon_enter_exit_olv2.h"

#include "jni.h"
#include "jvmdi_clean.h"

#ifdef ORP_POSIX
#define SUSPEND_THREAD(x) 1
#define RESUME_THREAD(x) 1
#define OS_THREAD_INIT_2()
#define SET_THREAD_DATA_MACRO()
#define THREAD_CLEANUP()
#define BEGINTHREADEX_SUSPENDSTATE 1
unsigned __stdcall call_the_run_method2(void *p_xx);

#endif //ORP_POSIX

int next_thread_index = 1;  // never use zero for a thread index
unsigned int thread_local_storage_offset = 0;

#ifdef CONCURRENCY_ANALYSIS
FILE *f_concur;
#endif //#ifdef CONCURRENCY_ANALYSIS

#pragma warning(push) 
#pragma warning(disable:4035)
    
uint64 readTimeStampCounter()
{
#ifdef ORP_POSIX
    __asm__(
        "rdtsc" 
    );
#else
    _asm {
        rdtsc
    }
#endif 
} //readTimeStampCounter
#pragma warning(pop)


void orp_change_nursery(void *p_nursery) 
{

    p_TLS_orpthread->p_nursery = p_nursery;
#ifdef RECLAIM_EVERY_ALLOCATION
	p_TLS_orpthread->allocation_count = 0;
#endif

}


void *orp_get_nursery()
{
	// For GC_NONE_V0 and GC_FIXED_V1 this will be NULL.
	return p_TLS_orpthread->p_nursery;
}

void java_lang_Thread_sleep_generic(int64 msec) 
{
#ifdef CONCURRENCY_ANALYSIS
        uint64 start = readTimeStampCounter();
#endif //#ifdef CONCURRENCY_ANALYSIS

    assert(!((unsigned int)(msec >> 32))); // We currently ignore high 32 bits of msec.
    //printf("******************************to Sleep %d\n", p_TLS_orpthread->thread_handle);
    
    setup_gc_frame_context();
    
    assert(p_TLS_orpthread->gc_enabled_status == disabled);

	orp_enable_gc();    //vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
    //don't think we need this, remove it
    p_thread_lock->_lock_enum();  //with gc_enabled ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//orp_disable_gc();

    ORP_thread *p_thr = get_thread_ptr();

    DWORD stat;

    p_thr->interrupt_a_waiting_thread = false;

    stat = ResetEvent(p_thr->event_handle_notify_or_interrupt);  // throw away old SetEvent()s
    assert(stat);

    assert(p_thr->app_status == thread_is_running);
    p_thr->app_status = thread_is_sleeping;
    p_thr->gc_status = gc_at_safepoint;
    p_thr->which_trap = x_java_sleep;

    p_thread_lock->_unlock_enum(); //with gc_enabled vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
 
    assert(p_TLS_orpthread->gc_status == gc_at_safepoint);
    assert(p_TLS_orpthread->which_trap == x_java_sleep);

    while (1) {
        //orp_enable_gc();
        stat = WaitForSingleObject(p_thr->event_handle_notify_or_interrupt, (int)msec);
        //orp_disable_gc();

        if (stat == WAIT_TIMEOUT)
        {
#ifdef _DEBUG
            total_sleep_timeouts++;
#endif
            break;
        }

        if (p_thr->interrupt_a_waiting_thread == true) {
            assert(stat == WAIT_OBJECT_0);
            break;
        }

        // the sleep did not time out and nobody sent us an interrupt
        // the only other possibility is that this is a stale notify/notifyAll()
        //
        // if other threads did a notify()/notifyAll() and between
        // the time they selected the current thread and the time they 
        // do the notifyAll's SetEvent(), they get preempted for a long enough period of 
        // time such that the current thread gets to the above WaitForSingleEvent()
        // then we ignore this unblocking and loop back to the waitforsingleevent()
        // note that we re-wait for the same amount of msec.  This should not cause a problem
        // since pre-emptive multitasking guarantees a sleep() will be at least
        // mseconds or longer.  If the system is lightly loaded, the stale notify()s will
        // get flushed out quickly.  If the system is heavily loaded, the run queues
        // are long meaning a sleep will wakeup and go onto a long run queue anyway

#ifdef _DEBUG
        printf("NOTE: doing a java/lang/Sleep and got a stale notifyAll() %d\n",
                p_thr->thread_index);
#endif
    }

	//don't think we need this, remove it
    p_thread_lock->_lock_enum();  //with gc_enabled ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
    assert(p_thr->app_status == thread_is_sleeping);
    p_thr->app_status = thread_is_running;
    p_thr->gc_status = zero;
    p_thr->which_trap = x_nothing;

    orp_disable_gc(); //xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    if (p_thr->interrupt_a_waiting_thread == true)
    {
        // this can only happen if someone really did send us an interrupt
        p_thr->interrupt_a_waiting_thread = false;
#ifdef _DEBUG
        total_sleep_interrupts++;
#endif
		p_thread_lock->_unlock_enum(); 
        throw_java_exception("java/lang/InterruptedException");
    }

	p_thread_lock->_unlock_enum(); //with gc_disabled xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

	//printf("******************************finish sleep %d\n", p_TLS_orpthread->thread_handle);
#ifdef CONCURRENCY_ANALYSIS
        uint64 end = readTimeStampCounter();
#ifdef ORP_POSIX
        fprintf(f_concur, 
            "THREAD_SLEEP_START( tid = %d, time = %llu )\n",
            p_thr->thread_index,  start );
        fprintf(f_concur, 
            "THREAD_SLEEP_END( tid = %d, time = %llu )\n",
            p_thr->thread_index,  end );

#else
        fprintf(f_concur, 
            "THREAD_SLEEP_START( tid = %d, time = %I64u )\n",
            p_thr->thread_index,  start );
        fprintf(f_concur, 
            "THREAD_SLEEP_END( tid = %d, time = %I64u )\n",
            p_thr->thread_index,  end );

#endif //#ifdef ORP_POSIX
#endif //#ifdef CONCURRENCY_ANALYSIS

   
}

void java_lang_Thread_interrupt_generic(volatile Java_java_lang_Thread *p_java_thr)
{

    ORP_thread *p_thr = get_orp_thread_ptr((void *)p_java_thr);

    if (!p_thr) {
        printf("bad interrupt, index = %d\n", p_thr->thread_index);
        return;
    }

    p_thr->interrupt_a_waiting_thread = true;

    DWORD stat = SetEvent(p_thr->event_handle_notify_or_interrupt);
    assert(stat);
}

void internal_suspend_utility(ORP_thread * p_thr)
{ 
    if (p_thr == p_TLS_orpthread)
        return;  // trying to suspend ourself

    if (p_thr == 0)
        return;  // trying to suspend non-existant thread

    DWORD stat = SUSPEND_THREAD(p_thr);

    if (stat == 0xffFFffFF)
        return; // trying to suspend non-existant thread

    assert(stat != 0xffFFffFF); 

    int xx;
    for (xx = 0; xx < 10; xx ++) {

        if (in_busybit_critical_zone(p_thr) ) {

            stat = RESUME_THREAD(p_thr);
            if (stat == 0xffFFffFF)
                return; // trying to resume non-existant thread
            Sleep(10);  // allow target thread to get out of busybit area

            stat = SUSPEND_THREAD(p_thr);
            if (stat == 0xffFFffFF)
                return; // trying to suspend non-existant thread
        }
        else break;
    }
    assert(xx < 10);  // must be totally stuck in a busybit_critical_zone
}


unsigned java_lang_Thread_countStackFrames_generic(ORP_thread *p_orpthread) 
{
    assert(0); //DEPRICATED
    unsigned ret_val;
    assert(p_TLS_orpthread->gc_enabled_status == disabled);

    setup_gc_frame_context();

    orp_enable_gc();

    p_thread_lock->_lock_enum();

    orp_disable_gc();

    if (p_orpthread != p_TLS_orpthread) {
        p_thread_lock->_unlock_enum();
        throw_java_exception("java/lang/IlegalThreadState");
    }

    Frame_Context context;

    COUNTSTACKFRAME_MACRO();

    ret_val = orp_get_stack_depth(&context);

    p_thread_lock->_unlock_enum();
 
    return ret_val;
}


void java_lang_Thread_setPriority_generic(ORP_thread *p_orp_thread, long pri)
{
    assert(p_TLS_orpthread->gc_enabled_status == disabled);

    orp_enable_gc();

    p_thread_lock->_lock_enum();

    orp_disable_gc();

    assert(0); // fix next line
//    p_this->priority = pri;

    // NOTE: setPriority0 is actually called before the thread is started
    // in which case, p_orp_thread is null... Thread_start will then set the priority
    
    if(p_orp_thread == 0) {
        p_thread_lock->_unlock_enum();
        return;
    }
    if (p_orp_thread->app_status == zip) {
        p_thread_lock->_unlock_enum();
        return;
    }    
    
    int status = SetThreadPriority(p_orp_thread->thread_handle,
		                    THREAD_PRIORITY_NORMAL + pri - 5);
    if(status == 0) {
        DWORD error = GetLastError();
        printf ("java_lang_Thread_setPriority error = 0x%x\n", error);   
    }
    p_thread_lock->_unlock_enum();
} //java_lang_Thread_setPriority0

unsigned __stdcall call_the_run_method( void * p_xx )
{
    ORP_thread *p_orp_thread=(ORP_thread *)p_xx; 

    set_orp_last_java_frame(0);
    
	p_orp_thread->stack_key = get_stack_pointer() >> STACK_KEY_SHIFT;

    DWORD rstat = SetEvent(p_orp_thread->gc_resume_event_handle);
    assert(rstat);
    rstat = ResetEvent(p_orp_thread->event_handle_suspend0);
    assert(rstat);

#ifdef CONCURRENCY_ANALYSIS
    uint64 start_time = readTimeStampCounter();
#ifdef ORP_POSIX
    fprintf(f_concur, "THREAD_START( tid = %d, time = %llu )\n", p_orp_thread->thread_index, start_time );
#else
    fprintf(f_concur, "THREAD_START( tid = %d, time = %I64u )\n", p_orp_thread->thread_index, start_time );
#endif //#ifdef ORP_POSIX
#endif //#ifdef CONCURRENCY_ANALYSIS


	gc_thread_init();
    // Current implementation does one nursery per thread. 
	// GC_FIXED_V1 and GC_NONE_V0 gets NULL.

    SET_THREAD_DATA_MACRO();

    // Invoke Thread.run()  -- BUGBUG its an interface method but we cheat
    // by looking up "run" in the instance method instead of
    // going thru interface lookup
    String *name   = ORP_Global_State::loader_env->string_pool.lookup("run");
    String *descr  = ORP_Global_State::loader_env->string_pool.lookup("()V");
    Signature *sig = ORP_Global_State::loader_env->sig_table.lookup(name, descr);
    assert(sig);

    VTable *p_vtable = (p_orp_thread->p_java_lang_thread->vt);
    Method *run_method = class_lookup_method(p_vtable->clss, sig);
    if(!run_method){
	    orp_cout << "Class " << p_vtable->clss->name->bytes << "doesn't have run() method defined.\n";
	    //orp_exit(2);
    	run_method = class_lookup_method_recursive(p_vtable->clss, sig);

    }
    assert(run_method);

    int old_floating_point_state = 0;
    void setup_floating_point_state(int *);
    setup_floating_point_state(&old_floating_point_state);

    // Set the app_status to "running" just before entering Java code. It is 
    // "birthing" till now.
    p_orp_thread->app_status = thread_is_running;

    active_thread_count ++;

    // the thread that originally called java_lang_Thread_start() will wait for this event 
    DWORD stat = SetEvent(new_thread_started_handle);
    assert(stat);

    orp_execute_java_method(run_method, 0, p_orp_thread->p_java_lang_thread);

    void cleanup_floating_point_state(int);
    cleanup_floating_point_state(old_floating_point_state);

    assert(p_orp_thread->app_status == thread_is_running);
    p_orp_thread->app_status = thread_is_dying;

    // Invoke Thread.exit()
    name  = ORP_Global_State::loader_env->string_pool.lookup("exit");
    descr = ORP_Global_State::loader_env->string_pool.lookup("()V");
    sig   = ORP_Global_State::loader_env->sig_table.lookup(name, descr);
    assert(sig);

    Method *exit_method;
    Class *p_class;
    p_class = p_vtable->clss;
    while(p_class) {
        exit_method = class_lookup_method(p_class, sig);
        if (exit_method) break;
        p_class = p_class->super_class;
    }
    
    Class *clss = ORP_Global_State::loader_env->java_lang_Thread_Class;

    p_class = p_vtable->clss->super_class;
    bool inherits_from_thread = false;
    while(p_class) {
        if (p_class == clss) {
            inherits_from_thread = true;
            break;
        }
        p_class = p_class->super_class;
    }
    if ( (inherits_from_thread) && exit_method ) {
        orp_cout << flush;
       
        // reload pointer to a live Java Object (Java_java_lang_Thread) that GC _may_ have moved
        volatile Java_java_lang_Object * p_zz;
        p_zz = (volatile Java_java_lang_Object *)p_orp_thread->p_java_lang_thread;
        orp_execute_java_method(exit_method, 0, p_zz);
    }

	gc_thread_kill();
    // In our current one nursery per thread world we need to release this nursery.
    // In a nursery per CPU world we would do something else like not release the
    // nursery.
    void *spent_nursery = p_TLS_orpthread->p_nursery;
    p_TLS_orpthread->p_nursery = NULL; // orphan the spent nursery
    gc_release_nursery (spent_nursery); // release it to the spent list.

    // reload pointer to a live Java Object (Java_java_lang_Thread) that GC _may_ have moved
    volatile Java_java_lang_Object * p_vv;
    p_vv = (volatile Java_java_lang_Object *)p_orp_thread->p_java_lang_thread;
    assert (p_vv->vt); // Check that p_vv is a reasonable object with a vtable.

    orp_monitor_enter( (struct Java_java_lang_Object *)p_vv);  //vvvvvvvvvvvvvvvvvvvvvvvv
    // Reload p_vv since gc could happened in orp_monitor_enter().
    p_vv = (volatile Java_java_lang_Object *)p_orp_thread->p_java_lang_thread;

    assert (p_vv->vt);

    reset_alive_flag_in_thread_object(p_vv);

    java_lang_Object_notifyAll ( (struct Java_java_lang_Object *)p_vv);

    p_vv = (volatile Java_java_lang_Object *)p_orp_thread->p_java_lang_thread;

    orp_monitor_exit( (struct Java_java_lang_Object *)p_vv);  //^^^^^^^^^^^^^^^^^^^^^^^^^

    // Reload p_vv since gc could happened in orp_monitor_exit().
    //p_vv = (volatile Java_java_lang_Object *)p_orp_thread->p_java_lang_thread;

    // Gc can happen in the below but p_vv is protected.

    GC_Frame gcf1;
    orp_push_gc_frame(&gcf1, (void *)&p_vv, sizeof(void *) );
    orp_enable_gc();

    p_thread_lock->_lock_enum();

    orp_disable_gc();
    orp_pop_gc_frame(&gcf1);  

    assert (p_vv->vt);

    if ( !is_this_a_daemon_thread( (void *)p_vv) ) 
        non_daemon_thread_count--;   


    assert(p_orp_thread->gc_frames == 0);  

#ifdef CONCURRENCY_ANALYSIS
    uint64 end_time = readTimeStampCounter();
#ifdef ORP_POSIX
    fprintf(f_concur, "THREAD_END( tid = %d, time = %llu )\n", p_orp_thread->thread_index, end_time);
#else
    fprintf(f_concur, "THREAD_END( tid = %d, time = %I64u )\n", p_orp_thread->thread_index, end_time);
#endif //#ifdef ORP_POSIX
#endif //#ifdef CONCURRENCY_ANALYSIS

	free_this_thread_block( get_thread_ptr() );

    THREAD_CLEANUP();

    if (!non_daemon_thread_count) {
        DWORD stat = SetEvent(non_daemon_threads_dead_handle);
        assert(stat);
    }

    active_thread_count --;

    // turned off for now --> orp_monitor_singlethread();

    p_thread_lock->_unlock_enum();

	_endthreadex(99);
    return(99);
}
 

void java_lang_Thread_start_generic(volatile Java_java_lang_Object *p_this_volatile) 
{
    GC_Frame gcf1;
    orp_push_gc_frame(&gcf1, (void *)&p_this_volatile, sizeof(void *) );
    orp_enable_gc();

// get a nursery for child thread. this invocation previously is by child thread itself 
// in call_the_run_method()
    void *temp_nursery = gc_get_new_nursery();

    p_thread_lock->_lock_enum();

    orp_disable_gc();
    orp_pop_gc_frame(&gcf1);  

    //BUGBUG this should throw IllegalThreadStateException  
    // because field in use means thread is already running		
    assert(is_thread_private_data_field_in_use(p_this_volatile) == 0); 

    ORP_thread * p_orp_thread = get_a_thread_block();

    p_orp_thread->p_java_lang_thread = p_this_volatile;

    set_java_thread_private_data_field(p_this_volatile, p_orp_thread);
    set_alive_flag_in_thread_object(p_this_volatile);

    assert(is_thread_private_data_field_in_use(p_this_volatile) != 0); 

    p_orp_thread->thread_is_java_suspended = false;			
    p_orp_thread->p_nursery = temp_nursery;			

    if ( is_this_a_daemon_thread( (void *)p_this_volatile) == 0)
        non_daemon_thread_count++;

#ifdef LAZY_LOCK	
    if(! bMultithreaded){
        bMultithreaded = true;
        void * getaddress__orp_monitor_enter_naked();
        void * getaddress__orp_monitor_exit_naked();
        void * restore__orp_monitor_enter_naked(void *);
        void * restore__orp_monitor_exit_naked(void *);

        void * ss = (void *)getaddress__orp_monitor_enter_naked();
        restore__orp_monitor_enter_naked(ss);
        ss = (void *)getaddress__orp_monitor_exit_naked();
        restore__orp_monitor_exit_naked(ss);
        for(int i=0; i<(num_lazylock-(int)lazylist)/4; i++)
            orp_monitor_enter(lazylist[i]);

    }
#endif //#ifdef LAZY_LOCK

	p_orp_thread->thread_handle = (HANDLE)_beginthreadex( 
                                            (void *)0, (unsigned)(64*1024), 

                                            (unsigned(__stdcall *)(void *))call_the_run_method2, 

                                            (void *)p_orp_thread,

                                            (unsigned)0, // Just start the thread.

                                            (unsigned *)&p_orp_thread->thread_id);

    if (p_orp_thread->thread_handle == 0) {
        orp_cout << "Thread creation failed" << endl;
        orp_exit(1);
	}

    Sleep(0);

	// Thread is brought up running with the default priority.
    // This seems better than suspending and then setting the priority since
	// it works on Linux as well.
	// set_thread_priority(p_orp_thread, p_this_volatile);

	// the new thread just resumed above will set new_thread_started_handle
	int status;
    status = WaitForSingleObject(new_thread_started_handle, INFINITE);
    assert(status != WAIT_FAILED);

    p_thread_lock->_unlock_enum();
} //java_lang_Thread_start_generic


#ifdef ORP_POSIX
#pragma optimize("", off)
unsigned __stdcall call_the_run_method2(void *p_xx)
{   
#ifdef OBJECT_LOCK_V2
    ORP_thread *p_orp_thread;
    unsigned int stack_base = get_stack_pointer();
    stack_base &= STACK_MASK;
    
    p_orp_thread = (ORP_thread *)p_xx;
    assert(p_orp_thread);
    unsigned int new_thread_local_storage_offset =
                                (unsigned int)(&p_orp_thread) - stack_base;
    
    if(thread_local_storage_offset != new_thread_local_storage_offset ){
        printf("thread_local_storage_offset is %d, should be %d\n", new_thread_local_storage_offset,  thread_local_storage_offset);
        exit(9797);
    }
    assert(thread_local_storage_offset == new_thread_local_storage_offset);
    assert(p_orp_thread->app_status == thread_is_birthing);
#endif 
    call_the_run_method((void *)p_xx);

    return 1;
}
#pragma optimize("", on)

void _endthreadex(int zz)
{
    // on linux, this is a nop,
    // call_the_run_method2() simply returns into the linux kernel
}
#endif // ORP_POSIX
#endif //#ifdef OBJECT_LOCK_V2

