// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/loop_invariant_path.h,v 1.2 2001/08/13 09:54:43 xhshi Exp $
//


#include "flow_graph.h"
#include "expression.h"

extern bool transform_loop_invariant_path(Flow_Graph *f, Expressions &exprs);

// Conditions for this optimization to be carried out:
//   1. a normalized loop
//   1. an un-linearized for-loop: header == exit
//   2. one tail node, with instruction that does counter++ or counter--
class Loop_Invariant_Path
{
public:
    Loop_Invariant_Path(Cfg_Node *l, Cfg_Node *t, Cfg_Node *e, Inst *a, Inst *i, Inst *c, Flow_Graph *f, Expressions *h) : 
      _loop_header(l), _tail_block(t), _post_exit(e), _exit_condition(NULL), _loop_bound_reg(NULL),
      _init_inst(a), _induc_inst(i), _cmp_inst(c), fg(f), exprs(h), _successful(false)
    {
    }
    bool optimize(unsigned bv_size);
private:
    bool _traverse_blocks(Cfg_Node *node, Bit_Vector &live_reg, Bit_Vector &invariant_reg, 
        Bit_Vector &induced_reg, unsigned tn, bool recurring_opt);
    bool _process_block(Cfg_Node *node, Bit_Vector &live_reg, Bit_Vector &invariant_reg, 
        Bit_Vector &induced_reg, Inst *start_inst=NULL);
    void _transform_block(Cfg_Node *node);
    bool _check_recurring_opt(Cfg_Node *node);
    void _perform_recurring_opt(Cfg_Node *node);
    Cfg_Node *_loop_header;
    Cfg_Node *_tail_block;
    Cfg_Node *_post_exit;
    Cfg_Node *_exit_condition;
    Inst *_init_inst;
    Inst *_induc_inst;
    Inst *_cmp_inst;
    Reg_Operand *_loop_bound_reg;
    Flow_Graph *fg;
    Expressions *exprs;
    bool _successful;
};
