// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/local_cse.h,v 1.2 2001/08/13 09:54:43 xhshi Exp $
//

#ifndef _LOCAL_CSE_H_
#define _LOCAL_CSE_H_

#include "Mem_Manager.h"
#include "expression.h"
#include "dlink.h"
//
// use type_map to map array types "BCDFIJLS" to 0-12
//
extern char type_map['Z' - 'A'+1];

class Exp;       // forward declaration
class Kill_Set {
public:
    Kill_Set(Mem_Manager& mem, unsigned bv_size);
    bool is_in_kill_set(unsigned idx);
    void add_to_kill(unsigned idx);
    int  is_array_set(O3_Jit_Type ty) {
        return _array_type & (1<<type_map[((char)ty)-'A']);
    }
    void set_array(O3_Jit_Type ty) {
        _array_type |= (1<<type_map[((char)ty)-'A']);
    }
    void set_alias_across_call() {_alias_across_call = 1;}
    int  is_alias_across_call()  {return _alias_across_call;}
	void union_with(Kill_Set *ks);
    void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}

    const unsigned short max_bv_size; // bit vector size of opnds_kill
private:
    unsigned short _array_type;
    unsigned short _alias_across_call;
    unsigned *_opnds_kill; // for vreg, field, and static
};    


class Inst; // forward declaration
class LCSE : public Dlink {
    Inst *_live;
    Exp  *_exp;
public:

    LCSE() : _exp(NULL), _live(NULL) {}  // dummy header of double linked list
    LCSE(Exp *e) : _exp(e), _live(NULL) {}
    //
    // record that _exp->inst is live at the end of BB
    //
    void snap_shot_of_lcse() {
        assert(_exp->inst() != NULL);
        _live = _exp->inst();
        _exp->set_inst(NULL);
    }
	void enable_lcse() {
		assert(_live != NULL);
		_exp->set_inst(_live);
	}
    Exp  *exp()  {return _exp;}
    void set_exp(Exp *e) {_exp = e;}
    LCSE *next() {return (LCSE*)_next;}
    LCSE *prev() {return (LCSE*)_prev;}
    Inst *live() {assert(_live != NULL); return _live;}
    void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}
};

//
// manage all free LCSE
//
class LCSE_Pool {
    LCSE _free_list;
    Mem_Manager& _mm;
public:
    LCSE_Pool(Mem_Manager& m) : _mm(m) {}
    LCSE *alloc_lcse_for(Exp *e) { 
        if (_free_list.next() == &_free_list) // no free lcse
            return new (_mm) LCSE(e);
        else {
            LCSE *l = _free_list.next();
            l->unlink();
            l->set_exp(e);
            return l;
        }
    }
    void free(LCSE *lcse) {lcse->set_exp(NULL); lcse->insert_after(&_free_list);}
};

#define MAX_LIST_SIZE  128
#define MAX_CMP_LIST_SIZE 16
//
// keep all live local CSE
//   
class Live_LCSE {
public:
    Live_LCSE(LCSE_Pool& lp) : pool(lp), _list_size(0), _cmp_size(0) {}
    void rm_lcse_elem(LCSE *elem,int& size);
    void kill_lcse_contain(unsigned id);
    void kill_lcse_contain(Exp *e);
    void kill_lcse_contain_array(O3_Jit_Type ty);
    void kill_lcse_alias_call();
    void add_lcse(Exp *e);
	void snap_shot_of_lcse();
    void propagate_to(Live_LCSE &l, Exp *instanceof); // propagate lcse from this to l
    Inst_Exp *array_cmp(Exp *left, Exp *rght);
    void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}
    LCSE *lcse_list() {return &_list_head;}
    int  list_size()  {return _list_size;}
private:
    void insert_lcse_to_list(LCSE& head, int max_size, int& size, LCSE *l);
    LCSE_Pool& pool;
    LCSE _list_head;
    int  _list_size;  // num of elements in the list
    LCSE _array_cmp_head;
    int  _cmp_size;   // num of elements in the _array_cmp_head list

};

//
// a lcse is removed from lcse_list if the lcse's CONDITION is true
//
#define REMOVE_FROM_LCSE_LIST(list,sz,CONDITION)                  \
do {                                                              \
    for (LCSE *lcse = list.next(); lcse != &list; ) {             \
        LCSE *nxt = lcse->next();                                 \
        if (lcse->exp()->CONDITION)                               \
            rm_lcse_elem(lcse,sz);                                \
        lcse = nxt;                                               \
    }                                                             \
    assert(sz >= 0);                                              \
} while (0)                                                       \

#endif // _LOCAL_CSE_H_

