// jit_export.cpp

#include "defines.h"
#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include "orp_types.h"
#include "jit_intf.h"
#include "Code_Gen.h"
#include "gc_eh_support.h"
#include "jit_export.h"

JIT_Handle O3_Jit_Handle;
bool O3_no_cp = false;
bool O3_cp_hash = true;
bool O3_no_dumpjit = false;
bool O3_statistics = false;

bool Inner_O3_statistics = false ;
bool In_O3_statistics = false;
FILE* fp_O3_dumpjit_profile = NULL;
//ofstream g_cout("dump_jit_O3.txt") ;

bool O3_do_code_scheduling = true;
bool O3_priority_regalloc = true;
bool O3_bc_opt = true;
bool O3_lazy_exc = true;
bool O3_peephole = true;
bool O3_unsafe_fcmp = false;
unsigned O3_num_fp_globals = 3;

extern "C"
JITExport void JIT_init(JIT_Handle j)
{
    cout << "Initializing Level 3 JIT dll." << endl;
    O3_Jit_Handle = j;
    o3_jit = (JIT*)j;
}

extern "C"
JITExport void JIT_next_command_line_argument(const char *name, const char *arg)
{
    if(strcmp(name, "-jitO3"))
        return;

    char *method_str = "METHODS=";
    char *inline_str = "INLINE=";
    char *pass_arg_str = "PASSARGS=";
    char *dottab_str = "DOTFILES=";
    char *fpglobal_str = "fpglobals=";

    if (strncmp(arg, method_str, strlen(method_str)) == 0)
        O3_envvar_METHODS = arg + strlen(method_str);
    else if (strncmp(arg, inline_str, strlen(inline_str)) == 0)
        O3_envvar_INLINE = arg + strlen(inline_str);
    else if (strncmp(arg, pass_arg_str, strlen(pass_arg_str)) == 0)
        O3_envvar_ARGS = arg + strlen(pass_arg_str);
    else if (strncmp(arg, dottab_str, strlen(dottab_str)) == 0)
        O3_envvar_DOTFILES = arg + strlen(dottab_str);
    else if (strncmp(arg, fpglobal_str, strlen(fpglobal_str)) == 0)
        O3_num_fp_globals = atoi(arg + strlen(fpglobal_str));
    else if (strcmp(arg, "onefile") == 0)
        one_dot_file = true;
    else if (strcmp(arg, "bigdumpjit") == 0)
        extended_dumpjit = true;
    else if (strcmp(arg, "nocp") == 0)
        O3_no_cp = true;
    else if (strcmp(arg, "nosched") == 0)
        O3_do_code_scheduling = false;
    else if (strcmp(arg, "nocphash") == 0)
        O3_cp_hash = false;
    else if (strcmp(arg, "statistics") == 0)
        O3_statistics = true;
    else if (strcmp(arg, "nodumpjit") == 0)
        O3_no_dumpjit = true;
    else if (strcmp(arg, "nopriority") == 0)
        O3_priority_regalloc = false;
    else if (strcmp(arg, "bcopt") == 0)
        O3_bc_opt = false;
    else if (strcmp(arg, "lazyexc") == 0)
        O3_lazy_exc = false;
    else if (strcmp(arg, "nopeephole") == 0)
        O3_peephole = false;
    else if (strcmp(arg, "unsafe_fcmp") == 0)
        O3_unsafe_fcmp = true;
}

extern "C"
JITExport JIT_Result 
JIT_compile_method(Compile_Handle     compilation,              // in
                   Method_Handle      method,                   // in
                   JIT_Flags          flags                     // in
                   )
{
    Class_Handle c      = method_get_class(method);
    const Byte  *bc     = method_get_byte_code_addr(method);
    size_t       size   = method_get_byte_code_size(method);
    unsigned max_stack  = method_get_max_stack(method);
    unsigned max_locals = method_get_max_locals(method);

    JIT_Result res = O3_compile_method(compilation,
                                       c,
                                       method,
                                       bc,
                                       size,
                                       max_locals,
                                       max_stack,
                                       method_uses_fastcall(method),
                                       (flags.insert_write_barriers == TRUE));

    return res;
}

extern "C"
JITExport JIT_Result 
JIT_gen_method_info(Compile_Handle     compilation,              // in
                    Method_Handle      meth,                     // in
                    JIT_Flags          flags                     // in
                    )
{
    assert(0);  return JIT_FAILURE;
}

extern "C"
JITExport void
JIT_unwind_stack_frame(Method_Handle       method,               // in
                       Frame_Context      *context,              // in out
                       Boolean             is_first              // in
                       )
{
    GC_Map::unwind_stack_frame(method, context, is_first);
}

extern "C"
JITExport void 
JIT_get_root_set_from_stack_frame(Method_Handle         method,        // in
                                  GC_Enumeration_Handle enum_handle,   // in
                                  Frame_Context        *context,       // in out
                                  Boolean               is_first       // in
                                  )
{
    GC_Map::get_root_set_from_stack_frame(method, enum_handle, context, is_first);
}


extern "C"
JITExport Boolean
JIT_can_enumerate(Method_Handle method,
                  uint32        eip
                  )
{
    return GC_Map::can_enumerate(method, eip);
}

extern "C"
JITExport unsigned
JIT_num_breakpoints(Method_Handle method,
                    uint32        eip
                    )
{
    assert(0);
    return 0;
}

extern "C"
JITExport void
JIT_get_breakpoints(Method_Handle method,      // in
                    uint32        *bp,         // out
                    Frame_Context *context     // in out
                    )
{
    assert(0);
}

extern "C"
JITExport void
JIT_fix_handler_context(Method_Handle      method,                     // in
                        Frame_Context     *context,                    // in out
                        Boolean            is_first                    // in
                        )
{
    GC_Map::fix_handler_context(method, context, is_first);
}

extern "C"
JITExport void *
JIT_get_address_of_this(Method_Handle       method,                     // in
                        const Frame_Context *context,                    // in
                        Boolean             is_first                    // in
                        )
{
    return (void *)GC_Map::get_address_of_this(method, context, is_first);
}

extern "C"
JITExport Boolean
JIT_call_returns_a_reference(Method_Handle         method,              // in
                             const Frame_Context  *context              // in
                             )
{
    return GC_Map::call_returns_a_reference(method, context);
}

extern "C"
JITExport int32 
JIT_get_break_point_offset(Compile_Handle compilation,
                           Method_Handle  meth,
                           JIT_Flags      flags,
                           unsigned       bc_location)
{
    assert(0);  return 0;
} 

extern "C"
JITExport void *
JIT_get_address_of_var(Frame_Context *context,
                       Boolean       is_first,
                       unsigned      var_no)
{
    assert(0); return NULL;
}

extern "C"
JITExport void 
JIT_thread_recompile_methods() 
{
    assert(0);
}