// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/is_subclass_of.cpp,v 1.2 2001/08/13 09:54:43 xhshi Exp $
//


#include "defines.h"
#include <stdio.h>
#include "is_subclass_of.h"

// Determines whether ch1 is a subclass of ch2.
// Follow ch1's superclasses until ch2 or NULL is reached.
bool O3_is_subclass_of(Class_Handle ch1, Class_Handle ch2)
{
    while (ch1 != NULL)
    {
        if (ch1 == ch2)
            return true;
        ch1 = class_get_super_class(ch1);
    }
    return false;
}
