// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/level_1a_jit_intf.h,v 1.2 2001/08/13 09:59:59 xhshi Exp $
//



#ifndef _LEVEL_1A_JIT_INTF_H_
#define _LEVEL_1A_JIT_INTF_H_


#include "jit_intf_cpp.h"


class Level_1a_JIT: public JIT {
    JIT_Handle jit_handle;
public:
    //
    // Initialize the JIT.
    //
    Level_1a_JIT() : jit_handle(NULL) { init(); };
    ~Level_1a_JIT();


    void next_command_line_argument(const char *name, const char *arg);
    //
    // The ORP call into JIT to compile a method to generate method info
    //
    JIT_Result 
    gen_method_info(Compile_Handle      compilation,              // in
                    Method_Handle       method,                   // in
                    JIT_Flags           flags                     // in
                    );

    //
    // The ORP call into JIT to compile a method.
    //
    JIT_Result 
    compile_method(Compile_Handle      compilation,              // in
                   Method_Handle       method,                   // in
                   JIT_Flags           flags                     // in
                   );


    //
    // For exception handling.
    // Unwind a stack frame for a method give the context.
    // The is_first argument should be ignored for now.
    // 
    virtual void
    unwind_stack_frame(Method_Handle       method,                // in
                       Frame_Context      *context,               // in out
                       Boolean             is_first               // in
                       );

    //
    // Call from the ORP into the JIT.
    // The JIT:
    // 1. Enumerates all references for the current stack.
    //    The enumeration is precise, i.e., non-references are not
    //    enumerated.
    //    References are returned to the ORP with the orp_enumerate_root_reference
    //    call.  The enum_handle argument must be used in those callbacks.
    // 2. Unwinds the stack and modifies the context in-place.
    //
    void 
    get_root_set_from_stack_frame(Method_Handle          method,        // in
                                  GC_Enumeration_Handle  enum_handle,   // in
                                  Frame_Context         *context,       // in out
                                  Boolean                is_first       // in
                                  );




    Boolean 
    can_enumerate(Method_Handle method,
                  uint32        eip
                  );


    unsigned 
    num_breakpoints(Method_Handle method,
                    uint32        eip
                    );

    // The JIT needs to write the breakpoint addresses into bp[],
    // and to make context->p_eip point to the return eip for the method.
    void 
    get_breakpoints(Method_Handle method,      // in
                    uint32        *bp,         // out
                    Frame_Context *context     // in out
                    );



    void
    fix_handler_context(Method_Handle      method,              // in
                        Frame_Context     *context,             // in out
                        Boolean            is_first             // in
                        );



    void *
    get_address_of_this(Method_Handle         method,           // in
                        const Frame_Context  *context,          // in
                        Boolean               is_first          // in
                        );



    Boolean
    call_returns_a_reference(Method_Handle         method,              // in
                             const Frame_Context  *context              // in
                             );


    int
    get_break_point_offset(Compile_Handle compilation,         // in
                           Method_Handle  meth,                // in
                           JIT_Flags      flags,               // in
                           unsigned       bc_location          // in
                           );

    void *
    get_address_of_var(Frame_Context   *context,
                       Boolean         is_first,
                       unsigned        var_no);

    void 
    thread_recompile_methods();
}; //Level_1a_JIT


#endif
