 /**

  Copyright (C) 1997-1998 Intel Corporation. All rights reserved.

  ijitprof.h:  Header file for linking in with a JIT compiler for
	       VTune support.

**/

#ifndef __iJITProf_h__
#define __iJITProf_h__

#include "windows.h"

#ifdef __cplusplus
extern "C"{
#endif 

 typedef enum iJIT_jvm_event
 {
   // exception

   // stack is supplied
   iJVM_EVENT_TYPE_EXCEPTION_OCCURRED_S,       // An exception occurred.  The exception handler will be executed at method id
                                               // the EventSpecificData is the stack id passed during
                                               // iJVM_EVENT_TYPE_ENTER_NIDS (iJIT_Method_Id)

   // method name, Id and stack is supplied - PREFERED - Best Performance
   iJVM_EVENT_TYPE_EXCEPTION_OCCURRED_NIDS,    // An exception occurred.  The exception handler will be executed at method id
                                               // the EventSpecificData is (iJIT_Method_NIDS)

   // shutdown
   iJVM_EVENT_TYPE_SHUTDOWN,                   // Program exiting 
                                               // EventSpecificData is NA


   // JIT profiling
   iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED=13, // issued after method code jitted
                                         // into memory but before code is
                                         // executed
                                         // the EventSpecificData is an iJIT_Method_Load structure 

   iJVM_EVENT_TYPE_METHOD_UNLOAD_START,  // issued before unload. Method code will no
                                         // longer be executed, but code and info
                                         // are still in memory. The VTune profiler
                                         // may capture method code only at this point.
                                         // the EventSpecificData is the method id passed during
                                         // JVM_EVENT_TYPE_METHOD_LOAD_FINISHED (iJIT_Method_Id)

    // Method Profiling

   // method address is supplied - if used this will cause a problem with exceptions
   iJVM_EVENT_TYPE_ENTER_ADDR,           // issued when a method is about to be executed
                                         // the EventSpecificData is the method addr range passed during
                                         // JVM_EVENT_TYPE_METHOD_LOAD_FINISHED (iJIT_Method_Addr)

   iJVM_EVENT_TYPE_LEAVE_ADDR,           // issued when a method is about to be left
                                         // the EventSpecificData is the method addr range passed during
                                         // JVM_EVENT_TYPE_METHOD_LOAD_FINISHED (iJIT_Method_Addr)

   // method id is supplied  - if used this will cause a problem with exceptions 
   iJVM_EVENT_TYPE_ENTER_ID,             // issued when a method is about to be executed
                                         // the EventSpecificData is the method id passed during
                                         // JVM_EVENT_TYPE_METHOD_LOAD_FINISHED (iJIT_Method_Id)

   iJVM_EVENT_TYPE_LEAVE_ID,             // issued when a method is about to be left
                                         // the EventSpecificData is the method id passed during
                                         // JVM_EVENT_TYPE_METHOD_LOAD_FINISHED (iJIT_Method_Id)

   // method name, Id and stack is supplied - PREFERED - Best Performance, Most reliable
   iJVM_EVENT_TYPE_ENTER_NIDS,           // issued when a method is about to be executed
                                         // the EventSpecificData is (iJIT_Method_NIDS)

   // method name, Id and stack is supplied - PREFERED - Best Performance, Most reliable
   iJVM_EVENT_TYPE_LEAVE_NIDS,           // issued when a method is about to be left
                                         // the EventSpecificData is (iJIT_Method_NIDS)

   // only stack id is supplied 
   iJVM_EVENT_TYPE_LEAVE_S,              // issued when a method is about to be left
                                         // the EventSpecificData is the stack id passed during
                                         // iJVM_EVENT_TYPE_ENTER_NIDS (iJIT_Method_Id)

 } iJIT_JVM_EVENT;


 typedef enum _iJIT_ModeFlags
 {
     iJIT_NO_NOTIFICATIONS             = 0x0000,    // No need to Notify VTune, Since VTune is not running.

     iJIT_BE_NOTIFY_ON_LOAD            = 0x0001,    // when turned on the jit must call iJIT_NotifyEvent( iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED, ...) for all the method already jitted.
     iJIT_BE_NOTIFY_ON_UNLOAD          = 0x0002,    // when turned on the jit must call iJIT_NotifyEvent( iJVM_EVENT_TYPE_METHOD_UNLOAD_FINISHED, ...) for all the method that are unloaded

     iJIT_BE_NOTIFY_ON_METHOD_ENTRY    = 0x0004,    // when turned on the jit must instrument all the currently jited code with calls on method entries
     iJIT_BE_NOTIFY_ON_METHOD_EXIT     = 0x0008,    // when turned on the jit must instrument all the currently jited code with calls on method exit
     
 } iJIT_ModeFlags;


 typedef void (*iJIT_ModeChanged)(iJIT_ModeFlags Flags);  // called when the settings are changed with new settings


 typedef void (*iJIT_ModeChangedEx)(void *UserData, iJIT_ModeFlags Flags);  // called when the settings are changed with new settings


 // methods

     // call back function registration ... needed for profiling.
     // The Method pointed by NewModeCallBackFunc will be called upon a change of state
     void WINAPI iJIT_RegisterCallback(     
         iJIT_ModeChanged NewModeCallBackFunc); // The new mode call back routine


     void WINAPI iJIT_RegisterCallbackEx(     
         void *UserData,                            // Info from the user
         iJIT_ModeChangedEx NewModeCallBackFuncEx); // The new mode call back routine


     // An event is occuring in the JIT Compiler
     int WINAPI iJIT_NotifyEvent(
         iJIT_JVM_EVENT event_type,	// the event that occured

         void *EventSpecificData);	// Data for that event, or NULL if no data



 // Special Jit support - for method profiling

   // Special methods: with no param, the method addr will be found by looking at the stack for a return address. an will generate a call to iJIT_NotifyEvent(iJVM_EVENT_TYPE_ENTER/LEAVE_METHOD_ADDR, add_on_stack)

     // call that when A method is entered in the JITed code.  
     // this call must be done from within the jitted method.
     void iJIT_MethodEntered(void);

     // A method is exited in the JITed code.  
     // this call must be done from within the jitted method.
     void iJIT_MethodExited(void);
 

 // Data structures for the events.

     // iJVM_EVENT_TYPE_ENTER_METHOD_ADDR and
     // iJVM_EVENT_TYPE_LEAVE_METHOD_ADDR 

	typedef	struct _iJIT_Method_Addr {
         unsigned long    address;			// address within the method
	} *piJIT_Method_Addr, iJIT_Method_Addr;


     // structure for the events:
     // iJVM_EVENT_TYPE_METHOD_UNLOAD_START   
     // iJVM_EVENT_TYPE_ENTER_METHOD_ID       
     // iJVM_EVENT_TYPE_LEAVE_METHOD_ID 

	typedef	struct _iJIT_Method_Id {
         unsigned long    method_id;			// Id of the method (same as the one passed in the iJIT_Method_Load struct 
	} *piJIT_Method_Id, iJIT_Method_Id;


     // structure for the events:
     // iJVM_EVENT_TYPE_ENTER_NIDS,
     // iJVM_EVENT_TYPE_LEAVE_NIDS,
     // iJVM_EVENT_TYPE_EXCEPTION_OCCURRED_NIDS

	typedef	struct _iJIT_Method_NIDS{
         unsigned long    method_id;			// uniq method ID
         unsigned long    stack_id;
         char			 *method_name;			// methode name (just the method, without the class)
	} *piJIT_Method_NIDS, iJIT_Method_NIDS;

     // iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED  structure

	typedef	struct _LineNumberInfo {
		
		unsigned long	Offset;					// x86 Offset from the begining of the method
		unsigned long   LineNumber;				// source line number from the begining of the source file.

	} *pLineNumberInfo, LineNumberInfo;

	typedef	struct _iJIT_Method_Load {

         unsigned long    method_id;			// uniq method ID - can be any uniq value, (such as the mb)
         char			 *method_name;			// method name (can be with or without the class and signature, in any case the class name will be added to it)
		 unsigned long    method_load_address;	// virtual address of that method  - This determines the method range for the iJVM_EVENT_TYPE_ENTER/LEAVE_METHOD_ADDR events
         unsigned long    method_size;			// Size in memory - Must be exact
         unsigned long    line_number_size;		// Line Table size in number of entries - Zero if none
         pLineNumberInfo  line_number_table;	// Pointer to the begining of the line numbers info array
         unsigned long    class_id;				// uniq class ID
         char			 *class_file_name;		// class file name 
   	     char			 *source_file_name;		// source file name

	} *piJIT_Method_Load, iJIT_Method_Load;


#ifdef __cplusplus
}
#endif

#endif // __iJITProf_h__
