/**
   Copyright (C) 1997-1998 Intel Corporation. All rights reserved.

   ijitprof.c: APIs for linking into a JIT for VTune support.

**/

#include "iJITProf.h"

#pragma optimize( "", off )
											  
static FARPROC FUNC_iJIT_NotifyEvent=NULL;
static FARPROC FUNC_iJIT_RegisterCallback=NULL;
static FARPROC FUNC_iJIT_RegisterCallbackEx=NULL;

static int loadiJIT_Funcs();
static int iJIT_DLL_is_missing=0;

int WINAPI iJIT_NotifyEvent(iJIT_JVM_EVENT event_type, void *EventSpecificData)
{
    if (!FUNC_iJIT_NotifyEvent) // the function was not loaded yet
    {
        // is it already missing...
        if (iJIT_DLL_is_missing) return 0;

        // load the Function from the DLL
        if (!loadiJIT_Funcs()) return 0;
    }

    // call the function
    return (int) FUNC_iJIT_NotifyEvent(event_type, EventSpecificData);   
}

void WINAPI iJIT_RegisterCallback(iJIT_ModeChanged NewModeCallBackFunc) // The new mode call back routine
{
    if (!FUNC_iJIT_RegisterCallback) // the function was not loaded yet
    {
        // is it already missing... or the load of Functions from the DLL failed
        if (iJIT_DLL_is_missing || !loadiJIT_Funcs())
        {
            NewModeCallBackFunc(iJIT_NO_NOTIFICATIONS);  // then do not bother with notifications
            return;
        }
    }

    // call the function
    FUNC_iJIT_RegisterCallback(NewModeCallBackFunc);   
}

void WINAPI iJIT_RegisterCallbackEx(void *userdata, iJIT_ModeChangedEx NewModeCallBackFuncEx) // The new mode call back routine
{
    if (!FUNC_iJIT_RegisterCallbackEx) // the function was not loaded yet
    {
        // is it already missing... or the load of Functions from the DLL failed
        if (iJIT_DLL_is_missing || !loadiJIT_Funcs())
        {
            NewModeCallBackFuncEx(userdata, iJIT_NO_NOTIFICATIONS);  // then do not bother with notifications
            return;
        }
    }

    // call the function
    FUNC_iJIT_RegisterCallbackEx(userdata, NewModeCallBackFuncEx);   
}

void iJIT_MethodEntered (void)
{
    unsigned long ReturnAddress;

   // Getting the return address, i.e., the caller's address. 
//    __asm { push [esp+0x14]} // 0x14 is Compiler specific ... it was validated for MS VC++ 4.x and 5.x  
	__asm { push [ebp+0x4]}
    __asm { pop  ReturnAddress}

    iJIT_NotifyEvent(iJVM_EVENT_TYPE_ENTER_ADDR,  (void *)ReturnAddress);
}

void iJIT_MethodExited (void)
{
    unsigned long ReturnAddress;

   // Getting the return address, i.e., the caller's address. 
//    __asm { push [esp+0x14]} // 0x14 is Compiler specific ... it was validated for MS VC++ 4.x and 5.x
	__asm { push [ebp+0x4]}
    __asm { pop  ReturnAddress}

    iJIT_NotifyEvent(iJVM_EVENT_TYPE_LEAVE_ADDR,  (void *)ReturnAddress);
}



// returns zero on failure, one on success.
static int loadiJIT_Funcs()
{
    HINSTANCE m_libHandle;

    // Assumes that the DLL will not be found
    iJIT_DLL_is_missing = 1;
    FUNC_iJIT_NotifyEvent = NULL;
    FUNC_iJIT_RegisterCallback = NULL;
    FUNC_iJIT_RegisterCallbackEx = NULL;

    // First try to load the dll from the PATH...
    m_libHandle = LoadLibrary ("iJITProf.dll");

    if (!m_libHandle) // if it is not there try to look in the VTUNE Dir
    {
        HKEY hk;

        // try to get vtune directory from the registry
        if (RegOpenKey(HKEY_CURRENT_USER,"Software\\VB and VBA Program Settings\\VTune\\StartUp", &hk) == ERROR_SUCCESS)
        {
            int i;
            char szName[MAX_PATH+1];
            char szVal[MAX_PATH+1];
            DWORD cbName, cbVal;

            for (i=0; ;i++)
            {
                cbName = cbVal = MAX_PATH+1;
                if (RegEnumValue(hk, i, szName, &cbName, NULL, NULL, szVal, &cbVal) == ERROR_SUCCESS)
                {
                    // get vtune directory
                    if (!strcmp(szName, "VTUNEDIR"))
                    {
                        char *p, *q;

                        // trim
                        p=szVal;
                        while (*p==' ') p++;
                        q=p+strlen(p)-1;
                        while (*q==' ') *(q--)='\0';
                        if (*q == '\\') *q='\0';

                        // chdir to the vtune dir...
                        GetCurrentDirectory(MAX_PATH+1, szName);
                        SetCurrentDirectory(p);
                        
                        // load lib from the VTune Directory
                        m_libHandle = LoadLibrary (strcat(p,"\\iJITProf.dll"));

                        // restore current dir
                        SetCurrentDirectory(szName);
                        break;
                    }
                }
                else break;        
            }
        }

    }  

    // if not there exit.
    if (!m_libHandle) 
    {
        return 0;
    }

    // if there, load the function
    if (!(FUNC_iJIT_NotifyEvent = GetProcAddress(m_libHandle, "iJIT_NotifyEvent"))) 
    {
        // the function is missing wrong DLL!
        return 0;
    }

    // if there, load the function
    if (!(FUNC_iJIT_RegisterCallback = GetProcAddress(m_libHandle, "iJIT_RegisterCallback"))) 
    {
        // the function is missing wrong DLL!
        FUNC_iJIT_NotifyEvent = NULL;
        return 0;
    }

    if (!(FUNC_iJIT_RegisterCallbackEx = GetProcAddress(m_libHandle, "iJIT_RegisterCallbackEx"))) 
    {
        // the function is missing wrong DLL!
        FUNC_iJIT_NotifyEvent = NULL;
        FUNC_iJIT_RegisterCallback = NULL;
        return 0;
    }

    iJIT_DLL_is_missing = 0; // DLL is ok.

    return 1;
}


