// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/cse.h,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//


#ifndef _CSE_H_
#define _CSE_H_

class CSE_Exp {
	union {
		struct {
			unsigned short _bc_index;
			unsigned short _len;
        } cse_tag;
		unsigned _value;
	};
public:
	CSE_Exp () {cse_tag._bc_index = cse_tag._len = (short unsigned int)-1;}
    CSE_Exp (unsigned short idx, unsigned short l) 
    {cse_tag._bc_index = idx; cse_tag._len = l;}
        ////: _bc_index(idx), _len(l){}

    void *operator new(size_t sz,Mem_Manager& m) {
		return m.alloc(sz);
	}
	void reset() {cse_tag._bc_index = cse_tag._len = (short unsigned int)-1;}
	void set_exp(unsigned short idx, unsigned short l) {
		cse_tag._bc_index = idx; cse_tag._len = l;
	}
	void set_exp(CSE_Exp *exp) {_value = exp->_value;}
	short bc_index() {return cse_tag._bc_index;}
	short len() {return cse_tag._len;}
	void  enlarge_exp(int index) {
		cse_tag._len = index - cse_tag._bc_index + 1;
	}
	int match_CSE(unsigned char *first_bc, unsigned char *curr_bc) {
		unsigned char *cse = first_bc + cse_tag._bc_index;
		for (int i = 0; i < cse_tag._len; i++) 
			if (cse[i] != curr_bc[i]) return 0;
		return 1;
	}
	int is_CSE_cand() {return cse_tag._bc_index != 0xffff;}
	int is_combinable(CSE_Exp* e) {
		return (cse_tag._bc_index + cse_tag._len == e->bc_index());
	}
	void print(ostream& cout) {
		cout << "[" << cse_tag._bc_index << "," << cse_tag._len << "]";
	}
};

union Map_Entry; // forward declaration

#define MAX_SZ_CSE 16
#define MAX_SZ_CSE_KILL 256
#define MAX_POPPED_SRCS 4

class CSE {
	CSE_Exp **_cse;
	CSE_Exp _reg_cse[n_reg];
	unsigned _reg_kill_set[n_reg][MAX_SZ_CSE_KILL/32];
	char _reg_array_ty[n_reg];
	unsigned short _max_regs;
	unsigned short _top;
	unsigned short _size;
	unsigned short _next_src;
	CSE_Exp _popped_srcs[MAX_POPPED_SRCS];
public:
	CSE(Mem_Manager& mem, unsigned sz) : _size(sz), _top(0) {
		_cse = (CSE_Exp**)mem.alloc(sizeof(CSE_Exp*)*sz);
		for (unsigned i = 0; i < sz; i++)
			_cse[i] = new (mem) CSE_Exp;
		reset_popped_srcs();
		_max_regs = 3; // reg_manager at least uses all scratch registers
	}
	void *operator new(size_t sz,Mem_Manager& m) {
		return m.alloc(sz);
	}
	void clear_cse_stack() {
		_top = 0;
		_max_regs = 3; // by default use only 3 scratch regs
		for (int i = 0; i < _max_regs; i++)
			_reg_cse[i].reset(); 
	}
	void inc_cse_reg_upto(unsigned char leftover) {
		if (leftover == 0) // no leftover callee_save regs
			return;
		int i, new_max = _max_regs;
		for (i = edi_reg; i >= ebx_reg; i--)
			if (leftover & (1<<i)) {
				new_max = i + 1;
				break;
			}
		for (i = _max_regs; i < new_max; i++) _reg_cse[i].reset();
		_max_regs = new_max;
	}
	void reset_cse() {
		unsigned i;
		for (i = 0; i < _top; i++) _cse[i]->reset();
		for (i = 0; i < _max_regs; i++) _reg_cse[i].reset();
	}
	void reset_popped_srcs() { _next_src = 0;}
	void give_up_cse() {_next_src = MAX_POPPED_SRCS +1;}
	CSE_Exp *reg_exp(X86_Reg_No no) {return &_reg_cse[no];}
	void pop(unsigned n) {
		assert((n == 0 || _top > 0) && _top >= n);
		_top -= n;
	}
	void pop() {
		assert(_top > 0);
		if (_next_src < MAX_POPPED_SRCS)
			_popped_srcs[_next_src].set_exp(_cse[_top-1]);
		_next_src++;
		_top--;
	}
	void dup() {
		_top++;
		assert(_top <= _size);
		_cse[_top-1]->set_exp(_cse[_top-2]);
	}
	void combine(const unsigned char *first_bc,CSE_Exp *curr_exp,
				 Operand *dst,unsigned local_regs,unsigned is_long);
	void reset_reg_cse(X86_Reg_No no) {
		assert(no < _max_regs);
		_reg_cse[no].reset();
		for(unsigned i = 0; i < MAX_SZ_CSE_KILL/32; i++)
			_reg_kill_set[no][i] = 0;
		_reg_array_ty[no] = 0;
	}
	void compute_cse_kill_set(const unsigned char *first_bc, X86_Reg_No no);
	void update_dst_cse(Operand *dst);
	void update_cse(const unsigned char *first_bc,Operand *opnd,
	                unsigned local_regs,int ith_popped);
	void kill_reg_cse(int curr_bc_index,int var_no);
	void kill_reg_array_cse(int curr_bc_index,int array_ty);
	X86_Reg_No find_cse(const unsigned char *first_bc,
					    const unsigned char *last_bc,
					    const unsigned char *curr_bc);
	void map_offset(Map_Entry *map, int emitter_off,
					const unsigned char *first_bc,
					const unsigned char *cse_bc, int cse_len);
	void reset_cse_ith_entry(unsigned i) {_cse[i]->reset();}
};

extern char exp_len[]; // declared in Exp_Len.cpp

#endif // _CSE_H_
