// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/code_emitter.cpp,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//


#include "defines.h"
#include <iostream.h>
#include <string.h>
#include "code_emitter.h"

Code_Emitter::Code_Emitter(Mem_Manager& m,unsigned byteCodeSize) :
            _arena(NULL),_next(NULL),_end(NULL),_mem_manager(m) {
	_arena_begin_offset = 0;
	_alloc_arena(byteCodeSize * 8);
	//
	// For statistics
	//
	offset_buf = NULL ;
	offset_buf_offset = 0 ;
	prof_rec = NULL ;
	inner_bb_cnt_offset = 0 ;
}

Code_Emitter::~Code_Emitter() {}

void	Code_Emitter::_alloc_arena(unsigned size) {
	//
	// 12 bytes for the arena header!
	//
	if (_arena != NULL) {
		//
		// update the offset
		//
		_arena_begin_offset += _next - _arena->bytes;
		//
		// set the next_byte field of arena so we know where the
		// code ends
		//
		_arena->next_byte = _next;
	}
    _arena = init_arena(_mem_manager.alloc(size + sizeof(struct Arena *)+sizeof(char *)+sizeof(char *)),_arena,size);
    _next = _arena->next_byte;
	_end = _arena->last_byte;

}

unsigned Code_Emitter::estimate_mem_size(unsigned byteCodeSize) {
	//
	// the estimated size needed for emitting code is 2/3 N * 12
	// which is 8 * N.
	// The reasoning is that there are approximately one 12 byte x86 
	// instruction  per 2/3 bytes of byte code.  Also, we add 12 bytes
	// for the arena header size.
	//
	return (byteCodeSize * 8 + sizeof(struct Arena *)+sizeof(char *)+sizeof(char *));
}

unsigned Code_Emitter::get_size() {
	//
	// make sure the next_byte field of arena is up to date
	//
	_arena->next_byte = _next;
	unsigned size = 0;
	for (Arena *a = _arena; a != NULL; a = a->next_arena) {
		size += (a->next_byte - a->bytes);
	}
	return size;
}

char *Code_Emitter::_copy(char *buffer,Arena *a) {
	if (a == NULL)
		return buffer;
	buffer = _copy(buffer,a->next_arena);
	unsigned size = a->next_byte - a->bytes;
	memcpy(buffer,a->bytes,size);
	return buffer + size;
}

void	Code_Emitter::copy(char *buffer) {
	//
	// make sure the next_byte field of arena is up to date
	//
	_arena->next_byte = _next;
	//
	// copy arenas starting from first one
	// arenas are organized in a LIFO order
	//
	_copy(buffer,_arena);
}
