// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/debugger/debugger_ia32_list.cpp,v 1.2 2001/12/07 00:16:00 xli18 Exp $
//

#include "platform.h"
#include <stdio.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <iostream.h>
#include "environment.h"
#include "orp_types.h"
#include "object_layout.h"
#include "jit_intf_cpp.h"
#include "method_lookup.h"
#include "stack_manipulation.h"
#include "Class.h"
#include "sync_bits.h"

#include "compile.h"
#include "ini.h"

#ifdef ORP_POSIX
#include <unistd.h>

#else
#include <io.h>
//#include <orp_io.h>
#endif

#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "jvmdi_clean.h"
#include "orp_utils.h"

#include "jit_intf.h"

#include "level_1a_jit_intf.h"


#include "debugger_jvmdi_ia32.h"
#include "debugger_ia32_utils.h"
#include "debugger_ia32_list.h"

#ifdef ORP_POSIX
#include "platform2.h"
#endif

FILE *open_source_file_from_classpath(const String* src_file_name){
	
	FILE *file_handle= NULL;
	if (!src_file_name->bytes || *(src_file_name->bytes) == 0) {
        return NULL;
    }

	unsigned baselen = src_file_name->len;
	char basename[100];
	char filename[100];
   // __int64 file_len;
    String *class_file_name = 0;
    
	strcpy(basename, src_file_name->bytes);
	
	char *dir = ORP_Global_State::loader_env->classpath;
	do {
		if ((dir==NULL)||(!strcmp(dir,"")))
			return NULL;
		char *eos = strchr(dir,PATH_SEPARATOR);
		if (eos != NULL)
			*eos = '\0';

		unsigned dirlen = strlen(dir);
		strncpy(filename, dir, dirlen);
		if (dirlen != 0) {
			*(filename + dirlen) = DIR_SEPARATOR;
			dirlen++;
		}
		strcpy(filename + dirlen, basename);

		if (eos != NULL) 
				*eos = PATH_SEPARATOR;
		dir +=dirlen;

#ifdef ORP_NT
		file_handle = fopen(filename, "r");
#else
		file_handle = fopen(filename, "r");
#endif

		if (file_handle!=NULL) {
			orp_cout<<endl;
			orp_cout<<filename<<endl;
			return file_handle;  // success!
		}
	} while (1);
}

void list_source_file(Class *curr_class,uint32 curr_line_idx,char *src_file_path,bool show_all)
{
    FILE *src_file_handle = NULL;
    char one_line[100];
    memset(one_line,0,100*sizeof(char));

    const String *src_name = curr_class->src_file_name;
    FILE *open_source_file_from_classpath(const String*);
    src_file_handle = open_source_file_from_classpath(src_name);
    if (src_file_handle==NULL){
	    do {
		    if (!strcmp(src_file_path,"")) {
			    orp_cout<<" can't find src file,pls input directory(enter for cancel)"<<endl;
			    my_gets(buff);
			    if (!(*buff)) break;
			    strcpy(src_file_path,buff);
		    }
		    char file_name[100];
		    strcpy(file_name,src_file_path);
		    int len = strlen(file_name);
		    file_name[len]=DIR_SEPARATOR;
		    file_name[len+1] = 0;
		    strcat(file_name,src_name->bytes);
	    
    #ifdef ORP_NT
		    src_file_handle = fopen(file_name, "r");
    #else
		    src_file_handle = fopen(file_name, "r");
    #endif
		    if (src_file_handle!=NULL) {
			    orp_cout<<endl;
			    orp_cout<<file_name<<endl;
			    break;
		    } else 
			    strcpy(src_file_path,"");
	    } while (1);
    }

    // show 11 lines in src file.
    if (src_file_handle!=NULL){
	    int begin_line_idx = 1;
	    if (curr_line_idx > 10)
		    begin_line_idx = curr_line_idx - 10;
	    int end_line_idx = curr_line_idx+20;
	    if (show_all) 
            end_line_idx += 1000;
        int i=1;
	    for (i=1;i<begin_line_idx;i++){
		    fgets(one_line,100,src_file_handle);
	    }
	    for (i=begin_line_idx;i<end_line_idx;i++){
		    if (fgets(one_line,100,src_file_handle)!=NULL){
			    printf("%4d",i);
			    if ((unsigned)i==curr_line_idx)
				    orp_cout<<" => ";
			    else 
				    orp_cout<<"    ";
			    orp_cout<<one_line;
		    }else 
			    break;
	    }
	    orp_cout<<endl;
	    fclose(src_file_handle);
    }
				
}

void list_bytecode(Method *curr_method,uint32 curr_bytecode_idx){
    uint32 begin_bc_idx = 0;
    if (curr_bytecode_idx > 20) 
        begin_bc_idx = curr_bytecode_idx - 20;
    uint32 end_bc_idx = curr_bytecode_idx + 40;
    if (end_bc_idx > curr_method->get_byte_code_size())
        end_bc_idx = curr_method->get_byte_code_size();
    // the list arange is (curr_idx-20,crr_idx+40);

    uint32 bc_ip = begin_bc_idx;
    char *dis_bc(const Byte *bc_start, unsigned *bc_ip, char *buf, Method_Handle m);

    while (bc_ip < begin_bc_idx){
        dis_bc(curr_method->get_byte_code_addr(),(unsigned int *)&bc_ip,disasm_buffer,curr_method);
    }

    const char *clss_name = curr_method->get_class()->name->bytes;
    const char *meth_name = curr_method->get_name()->bytes;
    orp_cout<<endl<<" current method is "<<clss_name<<"."<<meth_name<<endl;

    while (bc_ip < end_bc_idx){
        if (bc_ip == curr_bytecode_idx)
            orp_cout<<" => ";
        else 
            orp_cout<<"    ";
        dis_bc(curr_method->get_byte_code_addr(),(unsigned int *)&bc_ip,disasm_buffer,curr_method);
        orp_cout<<disasm_buffer<<endl;
    }
}

