#!/bin/sh

if [ "$AS_HOME" = "" ];
then 
echo FATAL: AS_HOME has not been set. Please set AS_HOME for the deploying the Scheduler.ear successfully
exit 1
elif [	! -f $AS_HOME/bin/asadmin ]
then 
echo "AS_HOME has not been set correctly. Please set AS_HOME to Sun Java System Application Server directory" 
echo "Your AS_HOME is currently set to $AS_HOME. Please unset AS_HOME if Sun Java System Application Server is not installed on your machine." 
echo USAGE: sh Scheduler7.sh admin_password [admin_port] [admin_user]
exit 1
fi 

if [ "$1" = "" ];
then
echo FATAL: Please provide the admin password for deploying the Scheduler.ear successfully
echo USAGE: sh Scheduler7.sh admin_password [admin_port] [admin_user]
exit 1
fi

ADMIN_PORT=$2;export ADMIN_PORT
ADMIN_USER=$3;export $ADMIN_USER
if [ "$2" = "" ];
then
echo INFO: You have not specified the admin port as a argument to the Scheduler.sh script
echo INFO: 4848 will be used as the default.
ADMIN_PORT=4848;export ADMIN_PORT
fi

if [ "$3" = "" ];
then
echo INFO: You have not specified the admin username as a argument to the Scheduler.sh script
echo INFO: "admin" will be used as the default.
ADMIN_USER=admin;export ADMIN_PORT
fi

echo This script deploys the services ear on SJSAS 8.
$AS_HOME/bin/asadmin deploy -u $ADMIN_USER -w $1 -H localhost -p $ADMIN_PORT Scheduler7.ear 
