/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageHeader;
import org.netbeans.modules.xml.wsdl.model.Binding;

/**
 *
 * @author  Martin Grebac
 */
public class AddHeaderPanel extends javax.swing.JPanel {
    
    Binding binding = null;
    
    /**
     * Creates new form AddHeaderPanel
     */
    public AddHeaderPanel(Binding b) {
        super();
        initComponents();

        this.binding = b;

//        boolean rm = true;
//        if (binding != null) {
//            rm = RMModelHelper.isRMEnabled(binding);
//        }
        
        headerCombo.addItem(MessageHeader.ADDRESSING_TO);
        headerCombo.addItem(MessageHeader.ADDRESSING_FROM);
        headerCombo.addItem(MessageHeader.ADDRESSING_FAULTTO);
        headerCombo.addItem(MessageHeader.ADDRESSING_REPLYTO);
        headerCombo.addItem(MessageHeader.ADDRESSING_MESSAGEID);
        headerCombo.addItem(MessageHeader.ADDRESSING_RELATESTO);
        headerCombo.addItem(MessageHeader.ADDRESSING_ACTION);

//        if (rm) {
            headerCombo.addItem(MessageHeader.RM_ACKREQUESTED);
            headerCombo.addItem(MessageHeader.RM_SEQUENCEACK);
            headerCombo.addItem(MessageHeader.RM_SEQUENCE);
//        }
    }
    
    public boolean isAllHeaders() {
        return allHeadersChBox.isSelected();
    }

    public String getHeader() {
        return (String)headerCombo.getSelectedItem();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        headerLabel = new javax.swing.JLabel();
        headerCombo = new javax.swing.JComboBox();
        allHeadersChBox = new javax.swing.JCheckBox();

        headerLabel.setText(org.openide.util.NbBundle.getMessage(AddHeaderPanel.class, "LBL_AddHeader_HeaderLabel")); // NOI18N

        allHeadersChBox.setText(org.openide.util.NbBundle.getMessage(AddHeaderPanel.class, "LBL_AllHeaders")); // NOI18N
        allHeadersChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        allHeadersChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        allHeadersChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                allHeadersChBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(headerLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(headerCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(allHeadersChBox)
                .addContainerGap(112, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(headerLabel)
                    .add(headerCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(allHeadersChBox))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void allHeadersChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_allHeadersChBoxActionPerformed
        headerCombo.setEnabled(!allHeadersChBox.isSelected());
    }//GEN-LAST:event_allHeadersChBoxActionPerformed
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox allHeadersChBox;
    private javax.swing.JComboBox headerCombo;
    private javax.swing.JLabel headerLabel;
    // End of variables declaration//GEN-END:variables
    
}
