/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-200? Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.visualweb.project.jsf.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 * Wizard Panel UI that allows the user to select the Page Template
 * @author Winston Prakash
 */
public class PageLayoutChooserPanelGUI extends javax.swing.JPanel implements HelpCtx.Provider {

    private PageLayoutChooserPanel wizardPanel;

    /** Creates new form TemplatePanelVisual */
    public PageLayoutChooserPanelGUI(PageLayoutChooserPanel wizPanel) {
        initComponents();
        wizardPanel = wizPanel;
        templatesList.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        templatesList.setListData(wizardPanel.getPageLayoutList());
        templatesList.setCellRenderer(new CustomCellRenderer());
        wizardPanel.setSelectedPageLayout(wizardPanel.getPageLayoutList().get(0));
        templatesList.setSelectedIndex(0);
        descriptionArea.setBackground(previewPanel.getBackground());
    }
    
    @Override
    public String getName() {
        return NbBundle.getMessage(PageLayoutChooserPanelGUI.class, "LBL_PageLayoutsPanel_Name");
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        templatesListPanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        templatesList = new javax.swing.JList();
        previewPanel = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jPanel1 = new javax.swing.JPanel();
        previewIcon = new javax.swing.JLabel();
        jScrollPane3 = new javax.swing.JScrollPane();
        descriptionArea = new javax.swing.JTextArea();

        templatesList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        templatesList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                templatesListValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(templatesList);

        org.jdesktop.layout.GroupLayout templatesListPanelLayout = new org.jdesktop.layout.GroupLayout(templatesListPanel);
        templatesListPanel.setLayout(templatesListPanelLayout);
        templatesListPanelLayout.setHorizontalGroup(
            templatesListPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(templatesListPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 211, Short.MAX_VALUE))
        );
        templatesListPanelLayout.setVerticalGroup(
            templatesListPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, templatesListPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 303, Short.MAX_VALUE)
                .addContainerGap())
        );

        jScrollPane2.setBorder(null);

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(PageLayoutChooserPanelGUI.class, "PREVIEW_TITLE"))); // NOI18N
        jPanel1.setLayout(new java.awt.GridBagLayout());

        previewIcon.setText(org.openide.util.NbBundle.getMessage(PageLayoutChooserPanelGUI.class, "NO_PREVIEW_TEXT")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel1.add(previewIcon, gridBagConstraints);

        jScrollPane2.setViewportView(jPanel1);

        jScrollPane3.setBorder(null);

        descriptionArea.setColumns(15);
        descriptionArea.setEditable(false);
        descriptionArea.setLineWrap(true);
        descriptionArea.setRows(5);
        descriptionArea.setText(org.openide.util.NbBundle.getMessage(PageLayoutChooserPanelGUI.class, "NO_DESCRIPTION_TEXT")); // NOI18N
        descriptionArea.setBorder(null);
        jScrollPane3.setViewportView(descriptionArea);

        org.jdesktop.layout.GroupLayout previewPanelLayout = new org.jdesktop.layout.GroupLayout(previewPanel);
        previewPanel.setLayout(previewPanelLayout);
        previewPanelLayout.setHorizontalGroup(
            previewPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(previewPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(previewPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 216, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jScrollPane3, 0, 0, Short.MAX_VALUE))
                .addContainerGap())
        );
        previewPanelLayout.setVerticalGroup(
            previewPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, previewPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 205, Short.MAX_VALUE)
                .add(18, 18, 18)
                .add(jScrollPane3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(templatesListPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(18, 18, 18)
                .add(previewPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(templatesListPanel, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .add(previewPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

    private void templatesListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_templatesListValueChanged
        // When the user release the mouse button and completes the selection,
        // getValueIsAdjusting() becomes false
        if (!evt.getValueIsAdjusting()) {
            JList list = (JList) evt.getSource();
            PageLayoutData pageLayout = (PageLayoutData) list.getSelectedValue();
            wizardPanel.setSelectedPageLayout(pageLayout);
            if (pageLayout.getPreviewImage() != null) {
                previewIcon.setIcon(new ImageIcon(pageLayout.getPreviewImage()));
                previewIcon.setText("");
            } else {
                previewIcon.setIcon(null);
                previewIcon.setText(NbBundle.getMessage(PageLayoutChooserPanelGUI.class, "NO_PREVIEW_TEXT"));
            }
            descriptionArea.setText(pageLayout.getDescription());                                 
        }
    }//GEN-LAST:event_templatesListValueChanged
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea descriptionArea;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JLabel previewIcon;
    private javax.swing.JPanel previewPanel;
    private javax.swing.JList templatesList;
    private javax.swing.JPanel templatesListPanel;
    // End of variables declaration//GEN-END:variables

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PageLayoutChooserPanelGUI.class);
    }

    class CustomCellRenderer extends JLabel implements ListCellRenderer {

        CustomCellRenderer() {
            setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
        }

        public Component getListCellRendererComponent(JList list, Object value, // value to display
        int index, // cell index
        boolean isSelected, // is the cell selected
        boolean cellHasFocus) {
            PageLayoutData pageLayout = (PageLayoutData) value;
            setText(pageLayout.getName());
            if (pageLayout.getIcon() != null) {
                setIcon(new ImageIcon(pageLayout.getIcon()));
            }
            if (isSelected) {
                setBackground(list.getSelectionBackground());
                setForeground(list.getSelectionForeground());
            } else {
                setBackground(list.getBackground());
                setForeground(list.getForeground());
            }
            setEnabled(list.isEnabled());
            setFont(list.getFont());
            setOpaque(true);
            return this;
        }
    }
}