/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * AddSessionBeanToFormAction.java
 *
 * Created on May 11, 2004, 10:31 PM
 */

package org.netbeans.modules.visualweb.ejb.actions;

import org.netbeans.modules.visualweb.ejb.nodes.SessionBeanNode;
import java.awt.datatransfer.Transferable;
import org.netbeans.modules.visualweb.api.designerapi.DesignerServiceHack;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

/**
 * The action invoked when the user clicks on "Add to Page"
 * menu item on a session bean node
 *
 * @author dongmei cao
 */
public class AddSessionBeanToPageAction extends NodeAction {
    
    public AddSessionBeanToPageAction() {
    }
    
    protected boolean enable(org.openide.nodes.Node[] activatedNodes) {
        return DesignerServiceHack.getDefault().canDrop(null);
    }
    
    public org.openide.util.HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    public String getName() {
        return NbBundle.getMessage( AddSessionBeanToPageAction.class, "ADD_SESSION_BEAN_TO_PAGE" );
    }
    
    protected void performAction(org.openide.nodes.Node[] activatedNodes) {
        
        if( activatedNodes != null && activatedNodes.length > 0 ) {
            for( int i = 0; i < activatedNodes.length; i ++ ) {
                Node node = null;
                if(activatedNodes[i] instanceof FilterNode){
                    node = (Node) activatedNodes[i].getCookie(SessionBeanNode.class);
                }else{
                    node = activatedNodes[i];
                }
                if (node instanceof SessionBeanNode ) {
                    // Create transferable
                    Transferable transferable = ((SessionBeanNode)node).clipboardCopy();
                    
                    // Drop it
                    DesignerServiceHack.getDefault().drop(transferable);
                }
            }
        }
    }
    
    /** @return <code>false</code> to be performed in event dispatch thread */
    protected boolean asynchronous() {
        return false;
    }
    
}
