/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * DiagramStructureNavigator.java
 *
 * Created on December 8, 2005, 2:53 PM
 */

package org.netbeans.modules.uml.drawingarea.navigator;

import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import javax.swing.JPanel;
import javax.swing.tree.TreeModel;

/**
 *
 * @author  TreySpiva
 */
public class DiagramStructureNavigator extends JPanel
{
   private IDrawingAreaControl drawingArea = null;
   private TreeModel model = null;
    
   /** Creates new form DiagramStructureNavigator */
   public DiagramStructureNavigator(IDrawingAreaControl drawingArea)
   {
      initComponents();
      setDrawingArea(drawingArea);
      navigatorTree.setCellRenderer(new DiagramStrucutureRender());
   }

   public IDrawingAreaControl getDrawingArea()
   {
      return drawingArea;
   }

   public void setDrawingArea(IDrawingAreaControl drawingArea)
   {
      this.drawingArea = drawingArea;
   }
   
   public void refresh()
   {
      // First get all of the model elements that are on the diagram.
      ETList < IElement >  elements = getDrawingArea().getAllItems3();
      model = new NavigatorTreeModel(elements);
      navigatorTree.setModel(model);
      
   }
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
   private void initComponents()
   {
      navigatorScrollBar = new javax.swing.JScrollPane();
      navigatorTree = new javax.swing.JTree();

      navigatorScrollBar.setBorder(null);
      navigatorTree.setRootVisible(false);
      navigatorScrollBar.setViewportView(navigatorTree);

      org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
      this.setLayout(layout);
      layout.setHorizontalGroup(
         layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
         .add(navigatorScrollBar, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
      );
      layout.setVerticalGroup(
         layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
         .add(navigatorScrollBar, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 300, Short.MAX_VALUE)
      );
   }// </editor-fold>//GEN-END:initComponents
   
   // Variables declaration - do not modify//GEN-BEGIN:variables
   public javax.swing.JScrollPane navigatorScrollBar;
   public javax.swing.JTree navigatorTree;
   // End of variables declaration//GEN-END:variables
   
}
