/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * CmpEntityEjbPanel.java        November 3, 2003, 10:58 AM
 *
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.ejbmodule;

import javax.swing.JPanel;

import org.netbeans.modules.j2ee.sun.dd.api.ejb.Cmp;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseEjb;
import org.netbeans.modules.j2ee.sun.share.configbean.CmpEntityEjb;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;

/**
 *
 * @author  Rajeshwar Patil
 * @version %I%, %G%
 */
public class CmpEntityEjbPanel extends JPanel {

    private CmpEntityEjbCustomizer masterPanel;


    /** Creates new form CmpEntityEjbPanel */
    public CmpEntityEjbPanel(CmpEntityEjbCustomizer src) {
        this.masterPanel = src;
        initComponents();
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        mappingPropertiesLabel = new javax.swing.JLabel();
        mappingPropertiesTextField = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        mappingPropertiesLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Mapping_Properties").charAt(0));
        mappingPropertiesLabel.setLabelFor(mappingPropertiesTextField);
        mappingPropertiesLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Mapping_Properties_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        add(mappingPropertiesLabel, gridBagConstraints);
        mappingPropertiesLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Mapping_Properties_Acsbl_Name"));
        mappingPropertiesLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Mapping_Properties_Acsbl_Desc"));

        mappingPropertiesTextField.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Mapping_Properties_Tool_Tip"));
        mappingPropertiesTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                mappingPropertiesKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        add(mappingPropertiesTextField, gridBagConstraints);
        mappingPropertiesTextField.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Mapping_Properties_Acsbl_Name"));
        mappingPropertiesTextField.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Mapping_Properties_Acsbl_Desc"));

    }// </editor-fold>//GEN-END:initComponents

    private void mappingPropertiesKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_mappingPropertiesKeyReleased
        CmpEntityEjb theBean = masterPanel.getCmpEntityBean();
        if(theBean != null) {
            Cmp cmp = theBean.getCmp();
            String newMappingProperties = mappingPropertiesTextField.getText();
            String oldMappingProperties = theBean.getRefreshPeriodInSeconds();

            if(!Utils.strEquivalent(oldMappingProperties, newMappingProperties)) {
                if(Utils.notEmpty(newMappingProperties)) {
                    cmp.setMappingProperties(newMappingProperties);
                } else {
                    cmp.setMappingProperties(null);
                }

                theBean.firePropertyChange("cmpMappingProperties", oldMappingProperties, newMappingProperties); // NOI18N
                masterPanel.validateField(CmpEntityEjb.FIELD_CMP_MAPPINGPROPERTIES);
            }
        }
    }//GEN-LAST:event_mappingPropertiesKeyReleased


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel mappingPropertiesLabel;
    private javax.swing.JTextField mappingPropertiesTextField;
    // End of variables declaration//GEN-END:variables

    public void initFields(CmpEntityEjb theBean) {
        String mappingProperties = null;
        
        if(theBean != null) {
            mappingProperties = theBean.getCmp().getMappingProperties();
        }
        
        mappingPropertiesTextField.setText(mappingProperties);
    }     
    
}
