/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.sun.share.configbean;

import java.beans.*;
import org.openide.util.Exceptions;

public class ToolSideErrorBeanInfo extends SimpleBeanInfo {
	
	/**
	 * Gets the bean's <code>BeanDescriptor</code>s.
	 *
	 * @return BeanDescriptor describing the editable
	 * properties of this bean.  May return null if the
	 * information should be obtained by automatic analysis.
	 */
	public BeanDescriptor getBeanDescriptor() {
            BeanDescriptor beanDescriptor = new BeanDescriptor  ( ToolSideError.class , null );//GEN-HEADEREND:BeanDescriptor
            return beanDescriptor;
	}
	
	/**
	 * Gets the bean's <code>PropertyDescriptor</code>s.
	 *
	 * @return An array of PropertyDescriptors describing the editable
	 * properties supported by this bean.  May return null if the
	 * information should be obtained by automatic analysis.
	 * <p>
	 * If a property is indexed, then its entry in the result array will
	 * belong to the IndexedPropertyDescriptor subclass of PropertyDescriptor.
	 * A client of getPropertyDescriptors can use "instanceof" to check
	 * if a given PropertyDescriptor is an IndexedPropertyDescriptor.
	 */
	public PropertyDescriptor[] getPropertyDescriptors() {
            int PROPERTY_ddbeanText = 0;
            int PROPERTY_ddbeanXpath = 1;
            int PROPERTY_identity = 2;
            int PROPERTY_message = 3;
            
            PropertyDescriptor[] properties = new PropertyDescriptor[4];
            
            try {
                properties[PROPERTY_ddbeanText] = new PropertyDescriptor ( "ddbeanText", ToolSideError.class, "getDdbeanText", null );
                properties[PROPERTY_ddbeanXpath] = new PropertyDescriptor ( "ddbeanXpath", ToolSideError.class, "getDdbeanXpath", null );
                properties[PROPERTY_identity] = new PropertyDescriptor ( "identity", ToolSideError.class, "getIdentity", "setIdentity" );
                properties[PROPERTY_message] = new PropertyDescriptor ( "message", ToolSideError.class, "getMessage", null );
            } catch( IntrospectionException e) {
                Exceptions.printStackTrace(e);
            }
            return properties;
	}
	
	/**
	 * Gets the bean's <code>EventSetDescriptor</code>s.
	 *
	 * @return  An array of EventSetDescriptors describing the kinds of
	 * events fired by this bean.  May return null if the information
	 * should be obtained by automatic analysis.
	 */
	public EventSetDescriptor[] getEventSetDescriptors() {
            int EVENT_propertyChangeListener = 0;
            int EVENT_vetoableChangeListener = 1;
            
            EventSetDescriptor[] eventSets = new EventSetDescriptor[2];
            
            try {
                eventSets[EVENT_propertyChangeListener] = new EventSetDescriptor ( org.netbeans.modules.j2ee.sun.share.configbean.ToolSideError.class, "propertyChangeListener", java.beans.PropertyChangeListener.class, new String[] {"propertyChange"}, "addPropertyChangeListener", "removePropertyChangeListener" );
                eventSets[EVENT_propertyChangeListener].setHidden ( true );
                eventSets[EVENT_vetoableChangeListener] = new EventSetDescriptor ( org.netbeans.modules.j2ee.sun.share.configbean.ToolSideError.class, "vetoableChangeListener", java.beans.VetoableChangeListener.class, new String[] {"vetoableChange"}, "addVetoableChangeListener", "removeVetoableChangeListener" );
                eventSets[EVENT_vetoableChangeListener].setHidden ( true );
            } catch( IntrospectionException e) {
                Exceptions.printStackTrace(e);
            }
            return eventSets;
	}
	
    /**
     * Gets the bean's <code>MethodDescriptor</code>s.
     *
     * @return  An array of MethodDescriptors describing the methods
     * implemented by this bean.  May return null if the information
     * should be obtained by automatic analysis.
     */
    public MethodDescriptor[] getMethodDescriptors() {
        int METHOD_getDConfigBean0 = 0;
        int METHOD_notifyDDChange1 = 1;
        int METHOD_removeDConfigBean2 = 2;
        MethodDescriptor[] methods = new MethodDescriptor[3];
    
        try {
            methods[METHOD_getDConfigBean0] = new MethodDescriptor ( org.netbeans.modules.j2ee.sun.share.configbean.ToolSideError.class.getMethod("getDConfigBean", new Class[] {javax.enterprise.deploy.model.DDBeanRoot.class}));
            methods[METHOD_getDConfigBean0].setHidden ( true );
            methods[METHOD_getDConfigBean0].setDisplayName ( "" );
            methods[METHOD_notifyDDChange1] = new MethodDescriptor ( org.netbeans.modules.j2ee.sun.share.configbean.ToolSideError.class.getMethod("notifyDDChange", new Class[] {javax.enterprise.deploy.model.XpathEvent.class}));
            methods[METHOD_notifyDDChange1].setHidden ( true );
            methods[METHOD_notifyDDChange1].setDisplayName ( "" );
            methods[METHOD_removeDConfigBean2] = new MethodDescriptor ( org.netbeans.modules.j2ee.sun.share.configbean.ToolSideError.class.getMethod("removeDConfigBean", new Class[] {javax.enterprise.deploy.spi.DConfigBean.class}));
            methods[METHOD_removeDConfigBean2].setHidden ( true );
            methods[METHOD_removeDConfigBean2].setDisplayName ( "" );
        }
        catch( Exception e) {
            Exceptions.printStackTrace(e);
        }
        return methods;
    }
}

