/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.sapbusinessonediserverplugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.filesystems.FileUtil;

/**
 * Replaces strings in content being unzipped to customize the project name and other variables to
 * match what the user entered in the wizard.
 *
 *
 */
final class Substitutions {
    
    /**
     * Subsitute the local WS Host from the zip file.
    */
    InputStream substituteWSHost(long originalSize, InputStream input, String filename, String host) throws IOException {
        if (filename.endsWith(".gif") || filename.endsWith(".png") || filename.endsWith(".jar")) {
            return input;
        }        
        
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        FileUtil.copy(input, temp);
        byte[] b = temp.toByteArray();
        
        //XXX do we want default charset, or UTF-8 - UTF-8 I think...
        CharBuffer cb = Charset.defaultCharset().decode(ByteBuffer.wrap(b));
        String data = cb.toString();        
        // TODO: Replace it with const 
        String key = "http://localhost:8080/JavaToCOMBridge/JavaToCOMService?WSDL";
        String val = host;
        System.out.println("Replacing Web Service Host as "+host);
        Matcher m = Pattern.compile(key).matcher(data);
        data = m.replaceAll(val);       
        
        return new ByteArrayInputStream(data.getBytes());
    }
    
    /**
     * Subsitute the local WS Local Host from the zip file.
    */
    
    InputStream substituteWSLocalHost(long originalSize, InputStream input, String filename, String host) throws IOException {
        if (filename.endsWith(".gif") || filename.endsWith(".png") || filename.endsWith(".jar")) {
            return input;
        }
        
        
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        FileUtil.copy(input, temp);
        byte[] b = temp.toByteArray();
        
        //XXX do we want default charset, or UTF-8 - UTF-8 I think...
        CharBuffer cb = Charset.defaultCharset().decode(ByteBuffer.wrap(b));
        String data = cb.toString();        
        String key = "localhost_8080";
         String val = "JavaToCOMBridge";
        System.out.println("Replacing Local Host String as "+val);
        Matcher m = Pattern.compile(key).matcher(data);
        data = m.replaceAll(val);
        
        
        return new ByteArrayInputStream(data.getBytes());
    }
    
    /** 
      * This method is updating only the URL in the wsdl file and the catalog file
     */
     InputStream substituteSOAPAddress(long originalSize, InputStream input, String filename, String host) throws IOException {
        if (filename.endsWith(".gif") || filename.endsWith(".png") || filename.endsWith(".jar")) {
            return input;
        }
        
        
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        FileUtil.copy(input, temp);
        byte[] b = temp.toByteArray();
        
        //XXX do we want default charset, or UTF-8 - UTF-8 I think...
        CharBuffer cb = Charset.defaultCharset().decode(ByteBuffer.wrap(b));
        String data = cb.toString();               
       
        String key = "localhost:8080";
        if(host!=null)
        {
        int startIndex=host.indexOf("//");
        String tempIP=host.substring(startIndex+1);
         System.out.println("Temporary IP as found from host is  "+tempIP);
        StringTokenizer tok=new StringTokenizer(tempIP,"/");
        String IPAddress=(String)tok.nextElement(); 
        System.out.println("The IP as found from host is  "+IPAddress);
        //Here we need to find out the host and port
      
        Matcher m = Pattern.compile(key).matcher(data);
        data = m.replaceAll(IPAddress);
        }       
        
        return new ByteArrayInputStream(data.getBytes());
    }
    /**
     * Substitute the project name 
    */
    InputStream substituteProjectName(long originalSize, InputStream input, String filename, String projectName,String templateName) throws IOException {
        if (filename.endsWith(".gif") || filename.endsWith(".png") || filename.endsWith(".jar")) {
            return input;
        }        
        System.out.print("Project Name is "+projectName);
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        FileUtil.copy(input, temp);
        byte[] b = temp.toByteArray();        
        //XXX do we want default charset, or UTF-8 - UTF-8 I think...
        CharBuffer cb = Charset.defaultCharset().decode(ByteBuffer.wrap(b));
        String data = cb.toString();        
        
        String key = "<name>"+templateName+"</name>";
        String val = "<name>"+projectName+"</name>";
        Matcher m = Pattern.compile(key).matcher(data);
        data = m.replaceAll(val);      
        
        return new ByteArrayInputStream(data.getBytes());
    }  
    /**
     * Substitute the context path
    */
   
    InputStream substituteContextPath(long originalSize, InputStream input, String filename, String projectName,String templateName) throws IOException {
        if (filename.endsWith(".gif") || filename.endsWith(".png") || filename.endsWith(".jar")) {
            return input;
        }        
        System.out.print("Context Path is  "+projectName);
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        FileUtil.copy(input, temp);
        byte[] b = temp.toByteArray();        
        //XXX do we want default charset, or UTF-8 - UTF-8 I think...
        CharBuffer cb = Charset.defaultCharset().decode(ByteBuffer.wrap(b));
        String data = cb.toString();        
        
        String key = "<context-root>/"+templateName+"</context-root>";
        String val = "<context-root>/"+projectName+"</context-root>";
        Matcher m = Pattern.compile(key).matcher(data);
        data = m.replaceAll(val);      
        
        return new ByteArrayInputStream(data.getBytes());
    } 
}


