/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.php.model.impl.factory;

import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.php.model.Expression;
import org.netbeans.modules.php.model.SourceElement;
import org.netbeans.modules.php.model.impl.ArgumentsImpl;


/**
 * @author ads
 *
 */
public class ArgumentsBuilder {
    
    private static final String ECHO_ARGS       = "EchoArguments";  // NOI18N
    
    public static final String  DEFINE_ARG      = "DefineArgument"; // NOI18N
    
    private static final String INCLUDE_ARG     = "IncludeArgument";// NOI18N
    
    private static final String ARGS            = "Arguments";      // NOI18N

    private ArgumentsBuilder() {
    }
    
    
    public static ArgumentsBuilder getInstance() {
        return INSTANCE;
    }
    
    public SourceElement build( Expression expression, ASTNode node, 
            TokenSequence sequence ) 
    {
        String nt = node.getNT();
        // this is the case when arguments initially are MemberAccess node 
        ASTNode subNode = node.getNode( ARGS );
        
        assert nt.equals( ECHO_ARGS ) || nt.equals( DEFINE_ARG ) || 
            nt.equals( INCLUDE_ARG ) || nt.equals( ARGS ) || subNode != null; 
        return new ArgumentsImpl( expression , node , 
                subNode == null ? node :subNode , sequence );
    }

    private static final ArgumentsBuilder INSTANCE = new ArgumentsBuilder();
}
