/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.php.rt.providers.impl.actions;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.netbeans.api.project.Project;
import org.netbeans.modules.php.rt.spi.providers.Command;
import org.netbeans.modules.php.rt.spi.providers.Host;
import org.netbeans.modules.php.rt.spi.providers.WebServerProvider;
import org.netbeans.spi.project.ActionProvider;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;


/**
 * @author ads
 *
 */
public class RunCommand extends AbstractCommand implements Command, Cloneable {
    
    private static final String AMP                 = "&";                  // NOI18N

    private static final String EQUAL               = "=";                  // NOI18N

    private static final String QUEST               = "?";                  // NOI18N

    private static final String HTTP                = "http://";            // NOI18N
    
    private static final String LBL_MALFORMED_URL   = "LBL_MalformedUrl";   // NOI18N
    
    private static final String LBL_RUN             = "LBL_RunProject";     // NOI18N
    
    protected static final String RUN               = ActionProvider.COMMAND_RUN;

    /**
     * @param project
     */
    public RunCommand( Project project , WebServerProvider provider) 
    {
        super( project , provider );
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#clone()
     */
    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isEnabled() {
        return true;
    }

    /* (non-Javadoc)
     * @see java.lang.Runnable#run()
     */
    public void run() {
        refresh();
        Host host = getHost();
        if (!checkHost(host)) {
            return;
        }
        String name = host.getName();
        
        
        if (getFileObjects() == null) {
            openPathInBrowser(name, "" );
        }
        else {
            for ( FileObject fileObject : getFileObjects() ) {
                String path = getRelativeSrcPath(fileObject);
                if ( path != null ) {
                    path = '/'+path.replace( File.separatorChar, '/');
                    if ( !openPathInBrowser(name, path) ) {
                        break;
                    }
                }
                else {
                    // TODO 
                }
            }
        }
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.php.rt.spi.providers.Command#getId()
     */
    public String getId() {
        return RUN;
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.php.rt.spi.providers.Command#getLabel()
     */
    public String getLabel() {
        return NbBundle.getMessage( RunCommand.class , LBL_RUN );
    }
    
    /**
     * <p>
     * creates path to open in browser based on serverName and path
     * to file. Takes into account contect path specified in project.
     * </p>
     * <p>
     * Should be overriden to use another specific details in path
     * </p>
     * @param serverName - server name
     * @param path to file starting from project src root.
     */
    protected String getUrlTextToOpen(String serverName, String path){
        String urlText = HTTP + serverName + getContext() +path;
        return urlText;
    }
    
    /** 
     * opens path in browser.
     * uses @see getUrlText to create full path to open.
     */
    protected boolean openPathInBrowser( String serverName, String path ) {
        String urlText = appendParams( getUrlTextToOpen(serverName, path) );
        URL url;
        try {
            url = new URL( urlText );
        }
        catch (MalformedURLException e) {
            notifyMsg(LBL_MALFORMED_URL, urlText);
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, e);
            return false;
        }
        HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        return true;
    }
    
    protected String appendParams( String url ) {
        if ( myParams == null ) {
            return url;
        }
        StringBuilder builder = null;
        if ( url.contains( QUEST ) ){
            int indx = url.lastIndexOf( QUEST );
            if ( indx == url.length() -1 ) {
                builder = new StringBuilder( url );
            }
            else {
                builder = new StringBuilder( url );
                builder.append( AMP );
            }
        }
        else {
            builder = new StringBuilder( url );
            builder.append( QUEST );
        }
        appandParams( builder );
        return builder.toString();
    }
    
    protected void addParameter( String paramName , String paramValue ) {
        if ( myParams == null ) {
            myParams = new HashMap<String, String>();
        }
        myParams.put( paramName , paramValue );
    }
    
    private void appandParams( StringBuilder builder ) {
        for( Entry<String, String> entry : myParams.entrySet()) {
            builder.append( entry.getKey() );
            builder.append( EQUAL );
            builder.append( entry.getValue() );
        }
    }
    
    private Map<String, String> myParams; 
}
