/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.ruby.railsprojects.plugins;

/**
 *
 * @author  Tor Norbye
 */
public class InstallationSettingsPanel extends javax.swing.JPanel {
    
    /** Creates new form InstallationSettingsPanel */
    public InstallationSettingsPanel(Plugin plugin) {
        initComponents();
        nameField.setText(plugin.getName());
    }
    
    public void setMessage(String message) {
        messageLabel.setText(message);
    }
    
    public boolean isSvnExternals() {
        return subversionToggle.isSelected() && externalsRadio.isSelected();
    }

    public boolean isSvnCheckout() {
        return subversionToggle.isSelected() && checkoutRadio.isSelected();
    }
    
    
    public String getRevision() {
        String s = revisionField.getText().trim();
        return (subversionToggle.isSelected() && revisionCheckBox.isSelected()) ? s : null;
    }
    
    public String getPluginName() {
        return nameField.getText().trim();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        svnGroup = new javax.swing.ButtonGroup();
        revisionCheckBox = new javax.swing.JCheckBox();
        nameLabel = new javax.swing.JLabel();
        nameField = new javax.swing.JTextField();
        messageLabel = new javax.swing.JLabel();
        revisionField = new javax.swing.JTextField();
        subversionToggle = new javax.swing.JCheckBox();
        externalsRadio = new javax.swing.JRadioButton();
        checkoutRadio = new javax.swing.JRadioButton();

        org.openide.awt.Mnemonics.setLocalizedText(revisionCheckBox, org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "SpecificRev")); // NOI18N
        revisionCheckBox.setEnabled(false);
        revisionCheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        nameLabel.setLabelFor(nameField);
        org.openide.awt.Mnemonics.setLocalizedText(nameLabel, org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "InstallationSettingsPanel.nameLabel.text")); // NOI18N

        revisionField.setEnabled(false);

        org.openide.awt.Mnemonics.setLocalizedText(subversionToggle, org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "UseSvn")); // NOI18N
        subversionToggle.setMargin(new java.awt.Insets(0, 0, 0, 0));
        subversionToggle.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                toggledSubversion(evt);
            }
        });

        svnGroup.add(externalsRadio);
        org.openide.awt.Mnemonics.setLocalizedText(externalsRadio, org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "UseExternals")); // NOI18N
        externalsRadio.setEnabled(false);
        externalsRadio.setMargin(new java.awt.Insets(0, 0, 0, 0));

        svnGroup.add(checkoutRadio);
        checkoutRadio.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(checkoutRadio, org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "UseCheckout")); // NOI18N
        checkoutRadio.setEnabled(false);
        checkoutRadio.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(nameLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(nameField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 256, Short.MAX_VALUE))
                    .add(subversionToggle)
                    .add(layout.createSequentialGroup()
                        .add(22, 22, 22)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(checkoutRadio)
                            .add(externalsRadio)
                            .add(layout.createSequentialGroup()
                                .add(revisionCheckBox)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(revisionField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 164, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                    .add(messageLabel))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(nameLabel)
                    .add(nameField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(subversionToggle)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(checkoutRadio)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(externalsRadio)
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(revisionCheckBox)
                    .add(revisionField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(messageLabel)
                .addContainerGap(26, Short.MAX_VALUE))
        );

        revisionCheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "InstallationSettingsPanel.revisionCheckBox.AccessibleContext.accessibleDescription")); // NOI18N
        nameLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "InstallationSettingsPanel.nameLabel.AccessibleContext.accessibleDescription")); // NOI18N
        nameField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "InstallationSettingsPanel.nameField.AccessibleContext.accessibleName")); // NOI18N
        nameField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "InstallationSettingsPanel.nameField.AccessibleContext.accessibleDescription")); // NOI18N
        revisionField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "InstallationSettingsPanel.revisionField.AccessibleContext.accessibleName")); // NOI18N
        revisionField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "InstallationSettingsPanel.revisionField.AccessibleContext.accessibleDescription")); // NOI18N
        subversionToggle.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "InstallationSettingsPanel.subversionToggle.AccessibleContext.accessibleDescription")); // NOI18N
        externalsRadio.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "InstallationSettingsPanel.externalsRadio.AccessibleContext.accessibleDescription")); // NOI18N
        checkoutRadio.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "InstallationSettingsPanel.checkoutRadio.AccessibleContext.accessibleDescription")); // NOI18N

        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "InstallationSettingsPanel.AccessibleContext.accessibleName")); // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InstallationSettingsPanel.class, "InstallationSettingsPanel.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

private void toggledSubversion(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_toggledSubversion
    // Enable/disable other fields
    boolean enabled = subversionToggle.isSelected();
    revisionCheckBox.setEnabled(enabled);
    revisionField.setEnabled(enabled);
    externalsRadio.setEnabled(enabled);
    checkoutRadio.setEnabled(enabled);
}//GEN-LAST:event_toggledSubversion
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton checkoutRadio;
    private javax.swing.JRadioButton externalsRadio;
    private javax.swing.JLabel messageLabel;
    private javax.swing.JTextField nameField;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JCheckBox revisionCheckBox;
    private javax.swing.JTextField revisionField;
    private javax.swing.JCheckBox subversionToggle;
    private javax.swing.ButtonGroup svnGroup;
    // End of variables declaration//GEN-END:variables
    
}
