/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.masterfs.providers;

import java.awt.Image;
import java.beans.PropertyVetoException;
import java.io.IOException;
import org.openide.filesystems.FileSystem;

/**
 * An object that implements AutoMountProvider is called from MasterFileSystem and can affect
 * behaviour of MasterFileSystem. MasterFileSystem invokes individual AutoMountProviders to obtain
 * instance of FileSystem for defined mount point (see {@link #createFileSystem}).
 * If there exists at least one implementation of AutoMountProvider, which returns non null FileSystem,
 * then such FileSystem is mounted into MasterFileSystem. This mechanism can be called <b>automatic mounting</b>.
 *
 * So, AutoMountProvide must implement logic where (which mount point) and what to mount
 * (which FileSystem implementation) into MasterFileSystem.
 *
 * @see org.netbeans.modules.masterfs.providers.FileSystemProvider#initialize
 * @see org.netbeans.modules.masterfs.providers.MountSupport
 * @author  rm111737
 */
public abstract class AutoMountProvider {
    /** Provides filesystem with root defined by mountPoint or return null.
     * If method method isRootOfFileSystem returns false for the same mountPoint,
     * then method createFileSystem must return null.
     * And if method isRootOfFileSystem returns true, then method createFileSystem mustn't return null.
     * @param mountPoint corresponds to java.io.File.getAbstractPath
     * But be aware, that this doesn't mean, that such file must really exist.
     * mountPoint may also address virtual location.
     * @return instance of FileSystem or null. FileObject hierarchy within a delegate FileSystem
     *  must precisely match the File hierarchy and must not hide any files which exist on disk.
     */
    public abstract FileSystem createFileSystem (String mountPoint) throws IOException, PropertyVetoException ;

    /**
     * If method method isRootOfFileSystem returns false for the same mountPoint,
     * then method createFileSystem must return null.
     * And if method isRootOfFileSystem returns true, then method createFileSystem mustn't return null.
     * @param mountPoint corresponds to java.io.File.getAbstractPath
     * But be aware, that this doesn't mean, that such file must really exist.
     * mountPoint may also address virtual location.
     * @return true if mountPoint is expected to be root of  FileSystem, that provides
     * method {@link #createFileSystem}
     */
    public abstract boolean isRootOfFileSystem (String mountPoint);

    /**
     * Gets icon for filesystem with root defined by mountPoint or null. Null can be
     * returned only if method isRootOfFileSystem returns false for the same mountPoint.
     * @param mountPoint corresponds to java.io.File.getAbstractPath
     * But be aware, that this doesn't mean, that such file must really exist.
     * mountPoint may also address virtual location.
     * @param iconType constant to indicate icon (@see BeanInfo)
     * @return filesystem icon for filesystem with root defined by mountPoint or null
     */
    public Image getIcon (String mountPoint, int iconType) {
        return null;
    }

}
