/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.masterfs;

import java.util.Collections;
import java.util.WeakHashMap;

/**
 *
 * @author  rm111737
 */
final class SyncSection {
    /** sync. purpose*/
    private int exclusiveCounter;
    private int normalCounter;
    final private ThreadLocal normalCounterPerThread = new ThreadLocal();
    final private ThreadLocal exclusiveCounterPerThread = new ThreadLocal();
    final private Object sync = new Object();
    private static SyncSection instance;


    static SyncSection getDefault() {
        synchronized (Cache.class) {
            if (instance == null) {
                instance = new SyncSection();
            }
        }
        return instance;
    }

    /** Creates a new instance of SyncSection */
    private SyncSection() {
    }

    void enterSection() {
        synchronized (sync) {
            try {
                while ((exclusiveCounter - getValue(exclusiveCounterPerThread)) > 0) {
                    sync.wait();
                }

                normalCounter++;
                setValue(normalCounterPerThread, getValue(normalCounterPerThread) + 1);
            } catch (InterruptedException iex) {
                iex.printStackTrace();
            }
        }
    }

    void finishSection() {
        synchronized (sync) {
            normalCounter--;
            setValue(normalCounterPerThread, getValue(normalCounterPerThread) - 1);
            sync.notifyAll();
        }

    }

    /** there should be prevented to call exclusive section from norma sectin, because of
     * danger of deadlock. Thread, that enters exclusive section should avoid to keep
     * locks, that could prevent to finish normal section.
     */
    void enterExclusiveSection() {
        synchronized (sync) {
            try {
                while ((normalCounter - getValue(normalCounterPerThread)) > 0 ||
                        (exclusiveCounter - getValue(exclusiveCounterPerThread)) > 0) {
                    sync.wait();
                }
            } catch (InterruptedException iex) {
                iex.printStackTrace();
            }
            exclusiveCounter++;
            setValue(exclusiveCounterPerThread, getValue(exclusiveCounterPerThread) + 1);

        }
    }

    void finishExclusiveSection() {
        synchronized (sync) {
            exclusiveCounter--;
            setValue(exclusiveCounterPerThread, getValue(exclusiveCounterPerThread) - 1);
            sync.notifyAll();
        }
    }

    private int getValue(ThreadLocal thrVal) {
        Integer val = (Integer) thrVal.get();
        return (val != null) ? val.intValue() : 0;
    }

    private void setValue(ThreadLocal thrVal, int value) {
        thrVal.set(new Integer(value));
    }

}
