/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * Utils.java
 *
 * Created on April 5, 2007, 3:41 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.microedition.testme.rms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;

/**
 *
 * @author Pavel
 */
abstract class Utils {
    
    /** Creates a new instance of Utils */
    private Utils() {
    }
    
    public static String readString(InputStream in) throws IOException {
        StringBuffer sb = new StringBuffer();
        int c;
        while( (c=in.read()) > 0) {
            sb.append( (char)c);
        }
        return c == 0 ? sb.toString() : null;
    }

    public static void writeString(OutputStream out, final String str) throws IOException {
        int len = str.length();

        for (int i = 0; i < len; i++) {
            out.write( str.charAt(i));
        }
        out.write(0);
    }

    public static int readWord(InputStream in) throws IOException {
        int b1 = in.read();
        if ( b1 == -1) {
            return -1;
        }
        int b2 = in.read();
        if ( b2 == -1) {
            return -1;
        }
        b1 += b2 << 8;
        //Assert.check(b1 >= 0 && b2 < 0x10000, "WORD value out of bounds #1.");
        return b1;
    }

    public static void writeWord(OutputStream out, final int value) throws IOException {
        //Assert.check(value >= 0 && value < 0x10000, "WORD value out of bounds #2.");
        out.write( value & 0xFF);
        out.write(value >> 8);
    }
    
    public static String toString(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        StringBuffer sb = new StringBuffer();
        sb.append( cal.get(Calendar.YEAR));
        sb.append( '-');
        append( sb, cal.get(Calendar.MONTH), 2);
        sb.append( '-');
        append( sb, cal.get(Calendar.DAY_OF_MONTH), 2);
        sb.append( ' ');
        append( sb, cal.get(Calendar.HOUR_OF_DAY), 2);
        sb.append( ':');
        append( sb, cal.get(Calendar.MINUTE), 2);
        sb.append( ':');
        append( sb, cal.get(Calendar.SECOND), 2);
        return sb.toString();
    }
    
    private static void append( StringBuffer sb, int value, int size) {
        String str = String.valueOf(value);
        size -= str.length();
        while( size-- > 0) {
            sb.append('0');            
        }
        sb.append(str);        
    }
}
