<%@include file="/WEB-INF/jspf/header.jspf" %>
<%@ taglib prefix="exc" uri="/WEB-INF/tlds/Exc"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%> 

<h2>Exception <a href='detail.do?id=${exceptions.id}'>${exceptions.id}</a></h2>
<div>
            <table class="axial">
                <tr>
                    <th>Exception #:</th>
                    <td>${exceptions.id}</td>
                    <td>&nbsp;</td>
                    <th>VM:</th>
                    
                    <td>${exceptions.vm}</td>
                    <td>&nbsp;</td>
                    <th>&nbsp;</th>
                    <td></td>
                </tr>
                <tr>
                    <th>Component:</th>
                    
                    <td>
                        ${exceptions.component}
                    </td>
                    <td>&nbsp;</td>
                    <th>OS:</th>
                    <td>${exceptions.operatingsystem}</td>
                    <td>&nbsp;</td>
                    <td></td>
                    <td></td>
                    
                </tr>
                <tr>
                    <th>Subcomponent:</th>
                    <td>
                        ${exceptions.subcomponent}
                    </td>
                    <td>&nbsp;</td>
                    <th>Version:</th>
                    <td>${exceptions.productversion}</td>
                    
                    <td>&nbsp;</td>
                    <td rowspan="4"></td>
                    <td rowspan="4"></td>
                </tr>
                <tr>
                    <th>Summary:</th>
                    <td colspan="7">${exceptions.summary}</td>
                </tr>
                <tr>
                    <th>Message:</th>
                    <td colspan="7">${exceptions.stacktrace.message}</td>
                </tr>
                <tr>
                    <th>Issuezilla:</th>
                    <td><exc:issuezilla exceptions='${exceptions}'/></td>
                    <td>&nbsp;</td>
                    
                    <th>Duplicates:</th>
                    <td colspan="7"><exc:duplicates exceptions='${exceptions}'/></td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    
                </tr>
                <tr>
                    
                </tr>
                <tr>
                    <th>Duplicate Of:</th>
                    <td colspan="7"><a href='detail.do?id=${exceptions.duplicateof.id}'>${exceptions.duplicateof.id}</a>
                    </td>
                </tr> 
            </table>
        </div>
        
    <div id="desc1" title="stacktrace">
        <h3>Stacktrace:</h3>
        <form action="stacktrace.do" method=GET  id="stacktracequery">
            <input type='hidden' name='id' value='${exceptions.id}'/>
            <exc:stacktrace stacktrace='${exceptions.stacktrace}' form='true' />
            <br/>
            <input type='submit' value='Find'/>
            <input type='reset' value='Reset'/>
        </form>
        <br/>
    </div>
    
    <div id="desc2" title="comments">
        <h3>Exceptions with similar Stacktrace:</h3>
        <table width = '90%'>
            <tr>
                <th>Id</th>
                <th>Summary</th>
                <th>OS</th>
                <th>JVM</th>
                <th>Build</th>
            </tr>
            <c:forEach var="exception" items='${list}' varStatus="stat">
                <tr class="${(stat.index % 2) == 0 ? "b" : "a"}">
                    <td><a href='detail.do?id=${exception.id}'>${exception.id}</a></td>
                    <td>${fn:substring(exception.summary,0,55)}</td>
                    <td>${exception.operatingsystem}</td>
                    <td>${exception.vm}</td>
                    <td>${exc:buildNumberFormatLong(exception.build)}</td>
                </tr>
            </c:forEach>
            count: ${fn:length(list)}<br/>
        </table>
    </div>
    
  
    <hr />
    
    <!--ENDING OF CLASS H2-->
</div>
<p></p><!--ENDING OF CLASS APP-->
<%@include file="/WEB-INF/jspf/footer.jspf" %>