/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.utils;

import java.lang.String;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
/**
 *
 * @author honza
 */
public class HttpUtils {

    private static final String URL_PART1 = "http://www.netbeans.org/issues/buglist.cgi?long_desc_type=regexp&long_desc=http%3A%5C%2F%5C%2Fanna.nbextras.org%5C%2Fexceptions%5C%2Fdetail.do%5C%3Fid%3D";
    private static final String URL_PART2 = "%5B%5E0-9%5D";
    private static boolean testMode = false;


    /**
     * @param args the command line arguments
     */

    public static boolean checkIssuezillaLogin(String username, String password) {
        Logger.getLogger(HttpUtils.class.getName()).log(Level.FINE, "CHECKING NAME");
        boolean response = false;
        HttpClient client = new HttpClient();
        //establish a connection within 5 seconds
        client.getHttpConnectionManager().
                getParams().setConnectionTimeout(20000);
        //client.getHostConfiguration().setProxy("host", 8080);
        PostMethod method = null;
        //create a method object
        method = new PostMethod("http://www.netbeans.org/servlets/TLogin");
        NameValuePair[] data = {
          new NameValuePair("loginID", username),
          new NameValuePair("password", password)
        };
        method.setRequestBody(data);
        //execute the method
        if (testMode) {
            if (username.equals("exceptions")&&(password.equals("petrzajac"))) response = true;
            else if (username.equals("tester")&&(password.equals("tester"))) response = true;
            else response = false;
        } else {
            try {
                client.executeMethod(method);
                Header header = method.getResponseHeader("Helmloginid");
                String login = header.getValue();
                if (login != null) {
                    response = (login.equals(username)) && (!login.equals("guest"));
                }
            } catch(Exception e) {
                e.printStackTrace();
            } finally {
                method.releaseConnection();
            }
        }
        return response;
    }

    public static Integer checkIssuezillaId(Integer id) {
        Integer issue = null;
        HttpClient client = new HttpClient();
        System.err.println("--- " + id);
        //establish a connection within 5 seconds
        client.getHttpConnectionManager().
                getParams().setConnectionTimeout(20000);
        //client.getHostConfiguration().setProxy("proxy.host", 8080);
        HttpMethod method = null;
        //create a method object
        method = new GetMethod(URL_PART1 + id + URL_PART2);
        method.setFollowRedirects(true);

        //execute the method
        try {
            client.executeMethod(method);
            String responseBody = method.getResponseBodyAsString();
            String target     = responseBody;
            String expression = "(<input type=\"hidden\" name=\"id\" value=\"(.*)\"./>)";
            Pattern p = Pattern.compile(expression);
            Matcher m = p.matcher(target);
            boolean result = m.find();
            if(result){
                Pattern pat = Pattern.compile(":");
                String[] items = pat.split(m.group(2));
                if (items.length > 0) {
                    issue = new Integer(items[0].trim());
                }
            }
        } catch(Exception e) {
            e.printStackTrace();
        } finally {
            method.releaseConnection();
        }
        System.err.println("--- " + issue);
        return issue;
    }

    public static void setTestMode(boolean mode) {
        testMode = mode;
    }
}
