/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Jan Horvath
 */
public class Components {
    private final ComponentComparator COMPARATOR = new ComponentComparator();
    
    public static final String COMPONENTS_FILENAME = "components.properties";
    
    public static String SETTINGS = "/space/exceptionsReporter/";
    
    static final Logger LOG = Logger.getLogger(Components.class.getName());
    
    Map<String, Set<String>> components = new TreeMap<String, Set<String>>(new ComponentComparator());
    
    private static Components instance = null;
    
    Timer timer;
    
    boolean initDone = false;
    
    private Components() {
        timer = new Timer();
        // update every 12 hours
        timer.schedule(new UpdateTask(), 0,  12 * 60 * 60 * 1000);
    }
    
    protected static Components getInstance() {
        synchronized (Components.class) {
            if (instance == null) {
                instance = new Components();
            }
        }
        return instance;
    }

    private void load(){
        LOG.info("Loading components:  " + SETTINGS);
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(SETTINGS + "/" + COMPONENTS_FILENAME));
            initDone = false;
            Enumeration comp = p.keys();
            while (comp.hasMoreElements()) {
                String component = (String) comp.nextElement();
                String[] subArray = p.getProperty(component).split(",");
                TreeSet<String> ts = new TreeSet<String>(COMPARATOR);
                ts.addAll(Arrays.asList(subArray));
                components.put(component, ts);
            }
            synchronized (this){
                initDone = true;
                notifyAll();
           }
        } catch (FileNotFoundException fileNotFoundException) {
            LOG.log(Level.SEVERE, "Unable to find components.properties", fileNotFoundException);
        } catch (IOException ioException) {
            LOG.log(Level.SEVERE, "Error reading components.properties", ioException);
        }
        LOG.info("Loading is done");
    }
    
    public boolean isInitDone() {
        return initDone;
    }
    
    public synchronized void waitInitDone(){
            while(!initDone){
                try {
                    wait(5000);
                } catch (InterruptedException ex) {
                    Logger.getLogger(Components.class.getName()).log(Level.SEVERE, "Waiting for loading components", ex);
            }
        }
    }
    
    public Set<String> getComponentsSet() {
        return Collections.unmodifiableSet(components.keySet());
    }
    
    public Set<String> getSubcomponentsSet(String component) {
        Set<String> subcomponents = components.get(component);
        if (subcomponents == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(subcomponents);
    }
    
    public static void setSettingsDirectory(String dir) {
        SETTINGS = dir;
    }
    
    class ComponentComparator implements Comparator<String> {
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
        
    }
    
    class UpdateTask extends TimerTask {
        public void run() {
            load();
        }
    }
}
