/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Ralph Krueger.
 */


package org.netbeans.modules.changelog.wizard;

/**
 *
 * @author  ralph
 */

import org.openide.util.*;
import javax.swing.event.*;
import javax.swing.*;
import org.netbeans.modules.changelog.*;

import java.io.*;

public class OutputPanel extends javax.swing.JPanel  {

    /** Creates new form OutputPanel */
    public OutputPanel() {
        initComponents();
        putClientProperty("WizardPanel_contentSelectedIndex", new Integer (1)); // NOI18N
        ButtonGroup group = new ButtonGroup();
        group.add(rbSortByDate);
        group.add(rbSortByUser);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(rbAscending);
        group2.add(rbDescending);
        btnXmlFile.setEnabled(false);// temporary
        btnHtmlFile.setEnabled(false);// temporary
        btnTextFile.setEnabled(false);// temporary
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        pnlSort = new javax.swing.JPanel();
        lblSort = new javax.swing.JLabel();
        rbSortByDate = new javax.swing.JRadioButton();
        rbSortByUser = new javax.swing.JRadioButton();
        lblOrder = new javax.swing.JLabel();
        rbAscending = new javax.swing.JRadioButton();
        rbDescending = new javax.swing.JRadioButton();
        lblInclude = new javax.swing.JLabel();
        cbSummary = new javax.swing.JCheckBox();
        cbQuery = new javax.swing.JCheckBox();
        cbBranchNames = new javax.swing.JCheckBox();
        pnlType = new javax.swing.JPanel();
        cbTextFile = new javax.swing.JCheckBox();
        txTextFile = new javax.swing.JTextField();
        btnTextFile = new javax.swing.JButton();
        cbXmlFile = new javax.swing.JCheckBox();
        txXmlFile = new javax.swing.JTextField();
        btnXmlFile = new javax.swing.JButton();
        cbHtmlFile = new javax.swing.JCheckBox();
        txHtmlFile = new javax.swing.JTextField();
        btnHtmlFile = new javax.swing.JButton();
        cbWindow = new javax.swing.JCheckBox();
        cbOutputWindow = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        setMinimumSize(new java.awt.Dimension(400, 200));
        setPreferredSize(new java.awt.Dimension(400, 200));
        getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSN_OutputPanel"));
        getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_OutputPanel"));
        pnlSort.setLayout(new java.awt.GridBagLayout());

        pnlSort.setMinimumSize(new java.awt.Dimension(553, 98));
        lblSort.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_lblSort_mnc").charAt(0));
        lblSort.setLabelFor(rbSortByDate);
        lblSort.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("HtmlPanel.lblSort.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        pnlSort.add(lblSort, gridBagConstraints);

        rbSortByDate.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_rbSortByDate_mnc").charAt(0));
        rbSortByDate.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.rbSortByDate.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 6, 0, 6);
        pnlSort.add(rbSortByDate, gridBagConstraints);

        rbSortByUser.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_rbSortByUSer_mnc").charAt(0));
        rbSortByUser.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.rbSortByUser.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 6, 6);
        pnlSort.add(rbSortByUser, gridBagConstraints);

        lblOrder.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_lblOrder_mnc").charAt(0));
        lblOrder.setLabelFor(rbAscending);
        lblOrder.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("HtmlPanel.lblOrder.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 6);
        pnlSort.add(lblOrder, gridBagConstraints);

        rbAscending.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_rbAscending_mnc").charAt(0));
        rbAscending.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.rbAscending.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 6);
        pnlSort.add(rbAscending, gridBagConstraints);

        rbDescending.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_rbDescending_mnc").charAt(0));
        rbDescending.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.rbDescending.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 6, 6);
        pnlSort.add(rbDescending, gridBagConstraints);

        lblInclude.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_lblInclude_mnc").charAt(0));
        lblInclude.setLabelFor(cbQuery);
        lblInclude.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("HtmlPanel.lblInclude.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 6);
        pnlSort.add(lblInclude, gridBagConstraints);

        cbSummary.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_cbSummary_mnc").charAt(0));
        cbSummary.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.cbSummary.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 12, 0, 6);
        pnlSort.add(cbSummary, gridBagConstraints);

        cbQuery.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_cbQuery_mnc").charAt(0));
        cbQuery.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.cbQuery.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 6);
        pnlSort.add(cbQuery, gridBagConstraints);

        cbBranchNames.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_cbBranchNames_mnc").charAt(0));
        cbBranchNames.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.cbBranchNames.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(2, 12, 0, 6);
        pnlSort.add(cbBranchNames, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 12);
        add(pnlSort, gridBagConstraints);

        pnlType.setLayout(new java.awt.GridBagLayout());

        pnlType.setMinimumSize(new java.awt.Dimension(481, 124));
        pnlType.setAutoscrolls(true);
        cbTextFile.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_cbTextFile_mnc").charAt(0));
        cbTextFile.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.cbTextFile.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 6);
        pnlType.add(cbTextFile, gridBagConstraints);

        txTextFile.setMinimumSize(new java.awt.Dimension(150, 17));
        txTextFile.setPreferredSize(new java.awt.Dimension(200, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 6);
        pnlType.add(txTextFile, gridBagConstraints);
        txTextFile.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_txTextFile"));

        btnTextFile.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.btnTextFile.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 6);
        pnlType.add(btnTextFile, gridBagConstraints);

        cbXmlFile.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_cbXmlFile_mnc").charAt(0));
        cbXmlFile.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.cbHtmlFile.title"));
        cbXmlFile.setLabel("XML File");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 6);
        pnlType.add(cbXmlFile, gridBagConstraints);

        txXmlFile.setMinimumSize(new java.awt.Dimension(150, 17));
        txXmlFile.setPreferredSize(new java.awt.Dimension(200, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 6);
        pnlType.add(txXmlFile, gridBagConstraints);
        txXmlFile.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_txXmlFile"));

        btnXmlFile.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.btnHtmlFile.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 6);
        pnlType.add(btnXmlFile, gridBagConstraints);

        cbHtmlFile.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_cbHtmlFile_mnc").charAt(0));
        cbHtmlFile.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.cbHtmlFile.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 6);
        pnlType.add(cbHtmlFile, gridBagConstraints);

        txHtmlFile.setMinimumSize(new java.awt.Dimension(150, 17));
        txHtmlFile.setPreferredSize(new java.awt.Dimension(200, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        pnlType.add(txHtmlFile, gridBagConstraints);
        txHtmlFile.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_txHtmlFile"));

        btnHtmlFile.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.btnHtmlFile.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 6);
        pnlType.add(btnHtmlFile, gridBagConstraints);

        cbWindow.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_cbWindow_mnc").charAt(0));
        cbWindow.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.cbWindow.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        pnlType.add(cbWindow, gridBagConstraints);

        cbOutputWindow.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_cbOutputWinow").charAt(0));
        cbOutputWindow.setText(org.openide.util.NbBundle.getBundle(OutputPanel.class).getString("OutputPanel.cbOutputWindow.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        pnlType.add(cbOutputWindow, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 12, 12);
        add(pnlType, gridBagConstraints);

    }//GEN-END:initComponents
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField txHtmlFile;
    private javax.swing.JPanel pnlType;
    private javax.swing.JCheckBox cbHtmlFile;
    private javax.swing.JCheckBox cbOutputWindow;
    private javax.swing.JRadioButton rbDescending;
    private javax.swing.JRadioButton rbAscending;
    private javax.swing.JCheckBox cbQuery;
    private javax.swing.JLabel lblSort;
    private javax.swing.JTextField txXmlFile;
    private javax.swing.JCheckBox cbSummary;
    private javax.swing.JCheckBox cbTextFile;
    private javax.swing.JLabel lblInclude;
    private javax.swing.JLabel lblOrder;
    private javax.swing.JButton btnTextFile;
    private javax.swing.JCheckBox cbXmlFile;
    private javax.swing.JRadioButton rbSortByDate;
    private javax.swing.JButton btnXmlFile;
    private javax.swing.JTextField txTextFile;
    private javax.swing.JPanel pnlSort;
    private javax.swing.JRadioButton rbSortByUser;
    private javax.swing.JButton btnHtmlFile;
    private javax.swing.JCheckBox cbBranchNames;
    private javax.swing.JCheckBox cbWindow;
    // End of variables declaration//GEN-END:variables


    public static class Panel implements org.openide.WizardDescriptor.FinishPanel {


        private OutputPanel panel;
        private String name;


        public Panel (String name) {
            this.name = name;
        }


        /** Get the component displayed in this panel.
         * @return the component
         */
        public synchronized java.awt.Component getComponent() {
            if (this.panel == null) {
                this.panel = new OutputPanel ();
                this.panel.setName (name);
            }
            return this.panel;
        }

        /** Help for this panel.
         * When the panel is active, this is used as the help for the wizard dialog.
         * @return the help or <code>null</code> if no help is supplied
         */
        public HelpCtx getHelp() {
            return new HelpCtx(this.getClass());
        }

        /** Add a listener to changes of the panel's validity.
         * @param l the listener to add
         * @see #isValid
         */
        public void addChangeListener(ChangeListener l) {
        }


        /** Remove a listener to changes of the panel's validity.
         * @param l the listener to remove
         */
        public void removeChangeListener(ChangeListener l) {
        }

        public boolean isValid() {
            return true;
        }

        /** Provides the wizard panel with the current data--either
         * the default data or already-modified settings, if the user used the previous and/or next buttons.
         * This method can be called multiple times on one instance of <code>WizardDescriptor.Panel</code>.
         * @param settings the object representing wizard panel state, as originally supplied to {@link org.openide.WizardDescriptor#WizardDescriptor(org.openide.WizardDescriptor.Iterator,Object)}
         * @exception IllegalStateException if the the data provided
         * by the wizard are not valid.
         */
        public void readSettings(Object settings) {
            if (settings instanceof ChangeLogProcessor) {
                OutputPanel p = (OutputPanel) this.getComponent();
                ChangeLogProcessor proces = (ChangeLogProcessor)settings;
                if (proces.getToTextFile() != null) {
                    p.txTextFile.setText(proces.getToTextFile().getAbsolutePath());
                    p.cbTextFile.setSelected(true);
                } else {
                    p.cbTextFile.setSelected(false);
                    p.txTextFile.setText("");
                }
                if (proces.getToHtmlFile() != null) {
                    p.txHtmlFile.setText(proces.getToHtmlFile().getAbsolutePath());
                    p.cbHtmlFile.setSelected(true);
                } else {
                    p.cbHtmlFile.setSelected(false);
                    p.txHtmlFile.setText("");
                }
                if (proces.getToXmlFile() != null) {
                    p.txXmlFile.setText(proces.getToXmlFile().getAbsolutePath());
                    p.cbXmlFile.setSelected(true);
                } else {
                    p.cbXmlFile.setSelected(false);
                    p.txXmlFile.setText("");
                }
                p.cbOutputWindow.setSelected(proces.isToOutputWindow());
                p.cbWindow.setSelected(proces.isViewInBrowser());
                if (proces.getSortMode() == ChangeLogProcessor.SORT_BY_USER) {
                    p.rbSortByUser.setSelected(true);
                } else
                    if (proces.getSortMode() == ChangeLogProcessor.SORT_BY_DATE) {
                        p.rbSortByDate.setSelected(true);
                    }
                if (proces.isDescendingSort()) {
                    p.rbDescending.setSelected(true);
                } else {
                    p.rbAscending.setSelected(true);
                }
                p.cbSummary.setSelected(proces.isIncludeSummary());
                p.cbQuery.setSelected(proces.isIncludeQueryDescription());
                p.cbBranchNames.setSelected(proces.isIncludeBranchNames());
            }
        }

        /** Provides the wizard panel with the opportunity to update the
         * settings with its current customized state.
         * Rather than updating its settings with every change in the GUI, it should collect them,
         * and then only save them when requested to by this method.
         * Also, the original settings passed to {@link #readSettings} should not be modified (mutated);
         * rather, the (copy) passed in here should be mutated according to the collected changes.
         * This method can be called multiple times on one instance of <code>WizardDescriptor.Panel</code>.
         * @param settings the object representing a settings of the wizard
         */
        public void storeSettings(Object settings) {
            if (settings instanceof ChangeLogProcessor) {
                OutputPanel p = (OutputPanel) this.getComponent();
                ChangeLogProcessor proces = (ChangeLogProcessor)settings;
                proces.setToOutputWindow(p.cbOutputWindow.isSelected());
                if (p.cbTextFile.isSelected() && p.txTextFile.getText().length() > 0) {
                    proces.setToTextFile(new File(p.txTextFile.getText()));
                } else {
                    proces.setToTextFile(null);
                }
                if (p.cbXmlFile.isSelected() && p.txXmlFile.getText().length() > 0) {
                    proces.setToXmlFile(new File(p.txXmlFile.getText()));
                } else {
                    proces.setToXmlFile(null);
                }
                if (p.cbHtmlFile.isSelected() && p.txHtmlFile.getText().length() > 0) {
                    proces.setToHtmlFile(new File(p.txHtmlFile.getText()));
                } else {
                    proces.setToHtmlFile(null);
                }
                if (p.rbSortByDate.isSelected()) {
                    proces.setSortMode(ChangeLogProcessor.SORT_BY_DATE);
                } else
                    if (p.rbSortByUser.isSelected()) {
                        proces.setSortMode(ChangeLogProcessor.SORT_BY_USER);
                    }
                proces.setDescendingSort(p.rbDescending.isSelected());
                proces.setIncludeQueryDescription(p.cbQuery.isSelected());
                proces.setIncludeSummary(p.cbSummary.isSelected());
                proces.setViewInBrowser(p.cbWindow.isSelected());
                proces.setIncludeBranchNames(p.cbBranchNames.isSelected());
            }
        }
    }

}
