/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.wlm.model.spi;

import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.wlm.model.api.WSDLReference;
import org.netbeans.modules.wlm.model.impl.WLMComponentBase;
import org.netbeans.modules.wlm.model.utl.Util;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.AbstractNamedComponentReference;

public abstract class WSDLReferenceImpl <T extends ReferenceableWSDLComponent> extends AbstractNamedComponentReference<T> implements WSDLReference<T> {

	public WSDLReferenceImpl(Class<T> referencedType, AbstractDocumentComponent parent, String ref) {
		super(referencedType, parent, ref);
		// TODO Auto-generated constructor stub
	}

	public WSDLReferenceImpl(T referenced, Class<T> referencedType, AbstractDocumentComponent parent) {
		super(referenced, referencedType, parent);
		// TODO Auto-generated constructor stub
	}
	
    /**
     * @return string to use in persiting the reference as attribute value of 
     * the containing component
     */
    public synchronized String getRefString() {
        if (refString == null) {
            assert super.getReferenced() != null;
            prefix = getParent().lookupPrefix(getEffectiveNamespace());
    		if (prefix == null) {
    			prefix = Util.getNewPrefix (WLMModel.class.cast(getParent().getModel()).getTasks());
    			WLMComponentBase.class.cast(WLMModel.class.cast(getParent().getModel()).getTasks()).addPrefix(prefix, getEffectiveNamespace());
    		}            
            localName = super.getReferenced().getName();
            if (prefix == null || prefix.length() == 0) {
                refString = localName;
            } else {
                refString = prefix + ":" + localName; //NOI18N
            }
        }
        return refString;
    }

    public String getEffectiveNamespace() {
        if (refString == null) {
            assert getReferenced() != null;
            return getReferenced().getModel().getDefinitions().getTargetNamespace();
        } else {
        	String prefix = getPrefix();
            return getParent().lookupNamespaceURI(getPrefix());
        }
    }
    
	public boolean isResolved() {
		// TODO Auto-generated method stub
		get();
		if (getReferenced() == null)
			return false;
		return true;
	}
      
    
}
